/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityParaChest;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockParaChest
extends BlockContainer
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    protected static final AxisAlignedBB NOT_CONNECTED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockParaChest(String assetName) {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c(assetName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public static boolean isOcelotBlockingChest(World par0World, BlockPos pos) {
        EntityOcelot entityocelot;
        Iterator iterator = par0World.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1))).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(entityocelot = (EntityOcelot)iterator.next()).func_70906_o());
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return NOT_CONNECTED_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        IInventory iinventory = this.getInventory(worldIn, pos);
        if (iinventory != null && playerIn instanceof EntityPlayerMP) {
            playerIn.openGui((Object)GalacticraftCore.instance, -1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityParaChest tileentitychest = (TileEntityParaChest)worldIn.func_175625_s(pos);
        if (tileentitychest != null) {
            tileentitychest.func_145836_u();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityParaChest tileentitychest = (TileEntityParaChest)worldIn.func_175625_s(pos);
        if (tileentitychest != null) {
            Random syncRandom = GCCoreUtil.getRandom(pos);
            for (int j1 = 0; j1 < tileentitychest.func_70302_i_(); ++j1) {
                ItemStack itemstack = tileentitychest.func_70301_a(j1);
                if (itemstack == null) continue;
                float f = syncRandom.nextFloat() * 0.8f + 0.1f;
                float f1 = syncRandom.nextFloat() * 0.8f + 0.1f;
                float f2 = syncRandom.nextFloat() * 0.8f + 0.1f;
                while (!itemstack.func_190926_b()) {
                    EntityItem entityitem = new EntityItem(worldIn, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), itemstack.func_77979_a(syncRandom.nextInt(21) + 10));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)syncRandom.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)syncRandom.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)syncRandom.nextGaussian() * f3;
                    worldIn.func_72838_d((Entity)entityitem);
                }
            }
            worldIn.func_175666_e(pos, null);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public IInventory getInventory(World par1World, BlockPos pos) {
        TileEntity object = par1World.func_175625_s(pos);
        if (object == null) {
            return null;
        }
        if (par1World.isSideSolid(pos.func_177972_a(EnumFacing.UP), EnumFacing.DOWN)) {
            return null;
        }
        if (BlockParaChest.isOcelotBlockingChest(par1World, pos)) {
            return null;
        }
        return (IInventory)object;
    }

    public TileEntity func_149915_a(World par1World, int meta) {
        return new TileEntityParaChest();
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR, FACING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityParaChest)) {
            return state;
        }
        TileEntityParaChest chest = (TileEntityParaChest)tile;
        return state.func_177226_a(COLOR, (Comparable)chest.color);
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }
}

