/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFuelerSingle;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPadSingle;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLandingPad
extends BlockAdvancedTile
implements IPartialSealableBlock,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumLandingPadType> PAD_TYPE = PropertyEnum.func_177709_a((String)"type", EnumLandingPadType.class);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);

    public BlockLandingPad(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 2; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    private boolean checkAxis(World worldIn, BlockPos pos, Block block, EnumFacing facing) {
        int sameCount = 0;
        for (int i = 1; i <= 3; ++i) {
            if (worldIn.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != block) continue;
            ++sameCount;
        }
        return sameCount < 3;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.dropEntireInventory(worldIn, pos, state);
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        Block id = GCBlocks.landingPad;
        if (!(this.checkAxis(worldIn, pos, id, EnumFacing.EAST) && this.checkAxis(worldIn, pos, id, EnumFacing.WEST) && this.checkAxis(worldIn, pos, id, EnumFacing.NORTH) && this.checkAxis(worldIn, pos, id, EnumFacing.SOUTH))) {
            return false;
        }
        if (worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() == GCBlocks.landingPad && side == EnumFacing.UP) {
            return false;
        }
        return this.func_176196_c(worldIn, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityLandingPadSingle();
            }
            case 1: {
                return new TileEntityBuggyFuelerSingle();
            }
        }
        return null;
    }

    @Override
    public boolean isSealed(World worldIn, BlockPos pos, EnumFacing direction) {
        return direction == EnumFacing.UP;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public String getShiftDescription(int meta) {
        if (meta == 0) {
            return GCCoreUtil.translate(this.func_149739_a() + ".description");
        }
        return GCCoreUtil.translate("tile.buggy_pad.description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PAD_TYPE, (Comparable)((Object)EnumLandingPadType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumLandingPadType)((Object)state.func_177229_b(PAD_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PAD_TYPE});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.PAD;
    }

    public static enum EnumLandingPadType implements IStringSerializable
    {
        ROCKET_PAD(0, "rocket"),
        BUGGY_PAD(1, "buggy");

        private static final EnumLandingPadType[] values;
        private final int meta;
        private final String name;

        private EnumLandingPadType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumLandingPadType byMetadata(int meta) {
            return values[meta % values.length];
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumLandingPadType.values();
        }
    }
}

