/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.entity;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;

public abstract class EntityTieredRocket
extends EntityAutoRocket
implements IRocketType,
IDockable,
IWorldTransferCallback,
ICameraZoomEntity {
    static boolean preGenInProgress = false;
    static Field marsConfigAllDimsAllowed;
    private final ArrayList<BlockVec3> preGenList = new ArrayList();
    public IRocketType.EnumRocketType rocketType;
    public float rumble;
    public int launchCooldown;
    private Iterator<BlockVec3> preGenIterator = null;

    public EntityTieredRocket(World par1World) {
        super(par1World);
        this.func_70105_a(0.98f, 4.0f);
    }

    public EntityTieredRocket(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    public void igniteCheckingCooldown() {
        if (!this.field_70170_p.field_72995_K && this.launchCooldown <= 0) {
            this.initiatePlanetsPreGen(this.field_70176_ah, this.field_70164_aj);
            this.ignite();
        }
    }

    private void initiatePlanetsPreGen(int cx, int cz) {
        this.preGenList.clear();
        if (this.destinationFrequency == -1 && !preGenInProgress) {
            ArrayList<Integer> toPreGen = new ArrayList<Integer>();
            for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
                if (planet.getDimensionID() == this.field_71093_bK || !planet.getReachable() || planet.getTierRequirement() > this.getRocketTier() || planet.getUnlocalizedName().equals("planet.asteroids")) continue;
                toPreGen.add(planet.getDimensionID());
            }
            if (toPreGen.size() > 0) {
                for (Integer dimID : toPreGen) {
                    this.preGenList.add(new BlockVec3(cx, dimID, cz));
                    if (!ConfigManagerCore.enableDebug) continue;
                    GCLog.info("Starting terrain pregen for dimension " + dimID + " at " + (cx * 16 + 8) + ", " + (cz * 16 + 8));
                }
                for (int r = 1; r < 12; ++r) {
                    int xmin = cx - r;
                    int xmax = cx + r;
                    int zmin = cz - r;
                    int zmax = cz + r;
                    for (int i = -r; i < r; ++i) {
                        for (Integer dimID : toPreGen) {
                            this.preGenList.add(new BlockVec3(xmin, dimID, cz + i));
                            this.preGenList.add(new BlockVec3(xmax, dimID, cz - i));
                            this.preGenList.add(new BlockVec3(cx - i, dimID, zmin));
                            this.preGenList.add(new BlockVec3(cx + i, dimID, zmax));
                        }
                    }
                }
                this.preGenIterator = this.preGenList.iterator();
                preGenInProgress = true;
            }
        } else {
            this.preGenIterator = null;
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.getWaitForPlayer()) {
            if (!this.func_184188_bt().isEmpty()) {
                Entity passenger = (Entity)this.func_184188_bt().get(0);
                if (this.ticks >= 40L) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184226_ay();
                        passenger.func_184205_a((Entity)this, true);
                        GCLog.debug("Remounting player in rocket.");
                    }
                    this.setWaitForPlayer(false);
                    this.field_70181_x = -0.5;
                } else {
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    passenger.field_70179_y = 0.0;
                    passenger.field_70181_x = 0.0;
                    passenger.field_70159_w = 0.0;
                }
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.launchCooldown > 0) {
                --this.launchCooldown;
            }
            if (this.preGenIterator != null) {
                if (this.preGenIterator.hasNext()) {
                    if (this.field_70170_p instanceof WorldServer) {
                        MinecraftServer mcserver = this.field_70170_p.func_73046_m();
                        BlockVec3 coords = this.preGenIterator.next();
                        WorldServer w = mcserver.func_71218_a(coords.y);
                        if (w != null) {
                            w.func_72964_e(coords.x, coords.z);
                            if (this.launchPhase < EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.preGenIterator.hasNext()) {
                                coords = this.preGenIterator.next();
                                w = mcserver.func_71218_a(coords.y);
                                w.func_72964_e(coords.x, coords.z);
                            }
                        }
                    }
                } else {
                    this.preGenIterator = null;
                    preGenInProgress = false;
                }
            }
        }
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        } else if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        double rumbleAmount = (double)this.rumble / (double)(37 - 5 * Math.max(this.getRocketTier(), 5));
        for (Entity passenger : this.func_184188_bt()) {
            passenger.field_70165_t += rumbleAmount;
            passenger.field_70161_v += rumbleAmount;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.lastLastMotionY = this.lastMotionY;
            this.lastMotionY = this.field_70181_x;
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        this.rocketType = IRocketType.EnumRocketType.values()[buffer.readInt()];
        super.decodePacketdata(buffer);
        if (buffer.readBoolean()) {
            this.field_70165_t = buffer.readDouble() / 8000.0;
            this.field_70163_u = buffer.readDouble() / 8000.0;
            this.field_70161_v = buffer.readDouble() / 8000.0;
        }
    }

    @Override
    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
        super.getNetworkedData(list);
        boolean sendPosUpdates = this.ticks < 25L || this.launchPhase < EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal();
        list.add(sendPosUpdates);
        if (sendPosUpdates) {
            list.add(this.field_70165_t * 8000.0);
            list.add(this.field_70163_u * 8000.0);
            list.add(this.field_70161_v * 8000.0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onReachAtmosphere() {
        block16: {
            block17: {
                block18: {
                    if (this.destinationFrequency == -1) break block16;
                    if (this.field_70170_p.field_72995_K) {
                        this.stopRocketSound();
                        return;
                    }
                    this.setTarget(true, this.destinationFrequency);
                    if (this.targetVec == null) break block17;
                    if (this.targetDimension == this.field_70170_p.field_73011_w.getDimension()) break block18;
                    WorldProvider targetDim = WorldUtil.getProviderForDimensionServer(this.targetDimension);
                    if (targetDim != null && targetDim.field_76579_a instanceof WorldServer) {
                        boolean dimensionAllowed;
                        boolean bl = dimensionAllowed = this.targetDimension == ConfigManagerCore.idDimensionOverworld;
                        if (targetDim instanceof IGalacticraftWorldProvider) {
                            dimensionAllowed = ((IGalacticraftWorldProvider)targetDim).canSpaceshipTierPass(this.getRocketTier());
                        } else if ((this.targetDimension > 1 || this.targetDimension < -1) && marsConfigAllDimsAllowed != null) {
                            try {
                                if (marsConfigAllDimsAllowed.getBoolean(null)) {
                                    dimensionAllowed = true;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (dimensionAllowed) {
                            if (!this.func_184188_bt().isEmpty()) {
                                Iterator e = this.func_184188_bt().iterator();
                                while (e.hasNext()) {
                                    Entity passenger = (Entity)e.next();
                                    if (!(passenger instanceof EntityPlayerMP)) continue;
                                    WorldUtil.transferEntityToDimension(passenger, this.targetDimension, (WorldServer)targetDim.field_76579_a, false, this);
                                }
                                return;
                            }
                            Entity e = WorldUtil.transferEntityToDimension(this, this.targetDimension, (WorldServer)targetDim.field_76579_a, false, null);
                            if (e instanceof EntityAutoRocket) {
                                e.func_70107_b((double)((float)this.targetVec.func_177958_n() + 0.5f), (double)(this.targetVec.func_177956_o() + 800), (double)((float)this.targetVec.func_177952_p() + 0.5f));
                                ((EntityAutoRocket)e).setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
                                ((EntityAutoRocket)e).setWaitForPlayer(false);
                                return;
                            }
                            GCLog.info("Error: failed to recreate the unmanned rocket in landing mode on target planet.");
                            e.func_70106_y();
                            this.func_70106_y();
                            return;
                        }
                    }
                    break block16;
                }
                this.func_70107_b((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f);
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.1;
                Iterator iterator = this.func_184188_bt().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
                        return;
                    }
                    Entity passenger = (Entity)iterator.next();
                    if (!(passenger instanceof EntityPlayerMP)) continue;
                    WorldUtil.forceMoveEntityToPos(passenger, (WorldServer)this.field_70170_p, new Vector3((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f), false);
                    this.setWaitForPlayer(true);
                    GCLog.debug("Rocket repositioned, waiting for player");
                }
            }
            GCLog.info("Error: the launch controlled rocket failed to find a valid landing spot when it reached space.");
            this.fuelTank.drain(Integer.MAX_VALUE, true);
            this.field_70163_u = Math.max(255.0, (this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0) - 200.0);
            return;
        }
        if (this.field_70170_p.field_72995_K) return;
        Iterator iterator = this.func_184188_bt().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.func_70106_y();
                return;
            }
            Entity e = (Entity)iterator.next();
            if (!(e instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)e;
            this.onTeleport(player);
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            WorldUtil.toCelestialSelection(player, stats, this.getRocketTier());
        }
    }

    @Override
    protected boolean shouldCancelExplosion() {
        return this.hasValidFuel() && Math.abs(this.lastLastMotionY) < 4.0;
    }

    public void onTeleport(EntityPlayerMP player) {
    }

    @Override
    protected void onRocketLand(BlockPos pos) {
        super.onRocketLand(pos);
        this.launchCooldown = 40;
    }

    @Override
    public void onLaunch() {
        super.onLaunch();
    }

    @Override
    protected boolean shouldMoveClientSide() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            return false;
        }
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().contains(player)) {
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, this.field_70170_p.field_73011_w.getDimension(), new Object[0]), (EntityPlayerMP)player);
                GCPlayerStats stats = GCPlayerStats.get((Entity)player);
                stats.setChatCooldown(0);
                float heightBefore = this.field_70131_O;
                this.field_70131_O /= 2.0f;
                this.func_184226_ay();
                this.field_70131_O = heightBefore;
            }
            return true;
        }
        if (player instanceof EntityPlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_DISPLAY_ROCKET_CONTROLS, this.field_70170_p.field_73011_w.getDimension(), new Object[0]), (EntityPlayerMP)player);
                GCPlayerStats stats = GCPlayerStats.get((Entity)player);
                stats.setChatCooldown(0);
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        nbt.func_74768_a("Type", this.rocketType.getIndex());
        super.func_70014_b(nbt);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        super.func_70037_a(nbt);
    }

    @Override
    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        if (this.rocketType == null) {
            return 2;
        }
        return this.rocketType.getInventorySpace();
    }

    @Override
    public void onWorldTransferred(World world) {
        if (this.targetVec != null) {
            this.func_70107_b((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f);
            this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LANDING);
            this.setWaitForPlayer(true);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        } else {
            this.func_70106_y();
        }
    }

    @Override
    public float getRotateOffset() {
        return -1.5f;
    }

    @Override
    public boolean isPlayerRocket() {
        return true;
    }

    static {
        try {
            Class<?> marsConfig = Class.forName("micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars");
            marsConfigAllDimsAllowed = marsConfig.getField("launchControllerAllDims");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

