/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.ranks;

import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesCommon;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.NodeEntry;
import com.feed_the_beast.ftbutilities.ranks.CommandOverride;
import com.feed_the_beast.ftbutilities.ranks.FTBUtilitiesPermissionHandler;
import com.feed_the_beast.ftbutilities.ranks.PlayerRank;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class Ranks {
    public static Ranks INSTANCE;
    public static Pattern RANK_NAME_PATTERN;
    public final Universe universe;
    public final Map<String, Rank> ranks;
    private Collection<String> rankNames;
    private Collection<String> permissionNodes;
    public final Map<UUID, PlayerRank> playerRanks;
    private Optional<Rank> defaultPlayerRank;
    private Optional<Rank> defaultOPRank;
    public final Map<String, CommandOverride> commands;
    private File ranksFile;
    private File playersFile;

    public static boolean isActive() {
        return FTBUtilitiesConfig.ranks.enabled && INSTANCE != null && PermissionAPI.getPermissionHandler() == FTBUtilitiesPermissionHandler.INSTANCE;
    }

    public static boolean isValidName(@Nullable String id) {
        return id != null && !id.isEmpty() && !id.equals("none") && RANK_NAME_PATTERN.matcher(id).matches();
    }

    public Ranks(Universe u) {
        this.universe = u;
        this.ranks = new LinkedHashMap<String, Rank>();
        this.rankNames = null;
        this.permissionNodes = null;
        this.playerRanks = new LinkedHashMap<UUID, PlayerRank>();
        this.defaultPlayerRank = null;
        this.defaultOPRank = null;
        this.commands = new LinkedHashMap<String, CommandOverride>();
        this.ranksFile = null;
        this.playersFile = null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean reload() {
        String[] s1;
        File badgeFile;
        this.ranks.clear();
        this.playerRanks.clear();
        this.clearCache();
        if (!Ranks.isActive()) {
            return true;
        }
        boolean save = false;
        this.ranksFile = new File(this.universe.server.func_71238_n(), "local/ftbutilities/ranks.txt");
        if (!this.ranksFile.exists()) {
            Rank pRank = new Rank(this, "player");
            pRank.add();
            pRank.setPermission("default_player_rank", true);
            pRank.setPermission("power", 1);
            pRank.setPermission("example.permission", true);
            pRank.setPermission("example.other_permission", false);
            pRank.setPermission("example.permission_with_value", 0);
            Rank vRank = new Rank(this, "vip");
            vRank.add();
            vRank.addParent(pRank);
            vRank.setPermission("power", 20);
            vRank.setPermission("ftbutilities.chat.name_format", "<&bVIP {name}&r>");
            vRank.setPermission("example.other_permission", true);
            vRank.setPermission("example.permission_with_value", 15);
            Rank aRank = new Rank(this, "admin");
            aRank.add();
            aRank.addParent(vRank);
            aRank.setPermission("default_op_rank", true);
            aRank.setPermission("power", 100);
            aRank.setPermission("ftbutilities.chat.name_format", "<&2{name}&r>");
            aRank.setPermission("example.permission_with_value", 100);
            PlayerRank fpRank = new PlayerRank(this, UUID.fromString("069be141-3c1b-45c3-b3b1-60d3f9fcd236"), "FakeForgePlayer");
            fpRank.add();
            fpRank.addParent(vRank);
            fpRank.setPermission("example.permission_with_value", 150);
            save = true;
        }
        Rank currentRank = null;
        String lastComment = "";
        for (Object line : DataReader.get((File)this.ranksFile).safeStringList()) {
            if (((String)line).isEmpty()) {
                lastComment = "";
                continue;
            }
            if (((String)line).startsWith("//")) {
                lastComment = ((String)line).substring(2).trim();
                continue;
            }
            if (((String)line).startsWith("[") && ((String)line).endsWith("]")) {
                String[] extendss;
                String[] stringArray;
                block34: {
                    String linein = ((String)line).substring(1, ((String)line).length() - 1);
                    if (linein.isEmpty()) {
                        currentRank = null;
                        continue;
                    }
                    stringArray = linein.split(" is ", 2);
                    extendss = stringArray[0].split(" extends ", 2);
                    String rankID = StringUtils.removeAllWhitespace((String)extendss[0]);
                    if (rankID.isEmpty()) {
                        currentRank = null;
                        continue;
                    }
                    UUID rankUUID = StringUtils.fromString((String)rankID);
                    currentRank = rankUUID != null && this.universe.getPlayer(rankUUID) != null ? this.getPlayerRank(this.universe.getPlayer(rankUUID).getProfile()) : new Rank(this, rankID);
                    currentRank.comment = lastComment;
                    lastComment = "";
                    if (!currentRank.isPlayer()) {
                        if (Ranks.isValidName(currentRank.getId())) {
                            currentRank.add();
                            currentRank.setPermission("power", String.valueOf(this.ranks.size()));
                            break block34;
                        } else {
                            currentRank = null;
                            continue;
                        }
                    }
                    save = true;
                }
                if (extendss.length == 2) {
                    currentRank.setPermission("parent", StringUtils.removeAllWhitespace((String)extendss[1]));
                    save = true;
                }
                if (stringArray.length != 2) continue;
                for (String tag : stringArray[1].split(",")) {
                    String s = StringUtils.removeAllWhitespace((String)tag);
                    if (s.isEmpty()) continue;
                    currentRank.setPermission(s, true);
                    save = true;
                }
                continue;
            }
            if (currentRank == null) continue;
            String[] s12 = ((String)line).split(":", 2);
            if (s12.length == 2) {
                Rank.Entry entry;
                void var7_11;
                String string = s12[1].trim();
                if (string.length() > 2 && string.startsWith("\"") && string.endsWith("\"")) {
                    String string2 = string.substring(1, string.length() - 1);
                    save = true;
                }
                if (!var7_11.isEmpty() && (entry = currentRank.setPermission(s12[0].trim(), var7_11)) != null) {
                    entry.comment = lastComment;
                }
            }
            lastComment = "";
        }
        File oldPlayerRanksFile = new File(this.universe.server.func_71238_n(), "local/ftbutilities/player_ranks.txt");
        if (oldPlayerRanksFile.exists()) {
            for (String s : DataReader.get((File)oldPlayerRanksFile).safeStringList()) {
                Rank rank;
                ForgePlayer player;
                String[] stringArray;
                if (s.isEmpty() || s.startsWith("//") || (stringArray = s.split(":", 2)).length != 2 || (player = this.universe.getPlayer((CharSequence)stringArray[0].trim())) == null || (rank = this.getRank(stringArray[1].trim())) == null || rank.isPlayer()) continue;
                this.getPlayerRank(player.getProfile()).addParent(rank);
            }
            oldPlayerRanksFile.delete();
            save = true;
        }
        if ((badgeFile = new File(this.universe.server.func_71238_n(), "local/ftbutilities/server_badges.txt")).exists()) {
            for (String string : DataReader.get((File)badgeFile).safeStringList()) {
                ForgePlayer player;
                if (string.isEmpty() || string.startsWith("//") || (s1 = string.trim().split(":", 2)).length != 2 || (player = this.universe.getPlayer((CharSequence)s1[0].trim())) == null) continue;
                this.getPlayerRank(player.getProfile()).setPermission("ftbutilities.badge", s1[1].trim());
            }
            badgeFile.delete();
            save = true;
        }
        this.playersFile = new File(this.universe.server.func_71238_n(), "local/ftbutilities/players.txt");
        currentRank = null;
        lastComment = "";
        for (String string : DataReader.get((File)this.playersFile).safeStringList()) {
            Rank.Entry entry;
            String value;
            if (string.isEmpty()) {
                lastComment = "";
                continue;
            }
            if (string.startsWith("//")) {
                lastComment = string.substring(2).trim();
                continue;
            }
            if (string.startsWith("[") && string.endsWith("]")) {
                String linein = string.substring(1, string.length() - 1);
                if (linein.isEmpty()) {
                    currentRank = null;
                    continue;
                }
                String[] iss = linein.split(" is ", 2);
                String[] extendss = iss[0].split(" extends ", 2);
                String rankID = StringUtils.removeAllWhitespace((String)extendss[0]);
                if (rankID.isEmpty()) {
                    currentRank = null;
                    continue;
                }
                UUID rankUUID = StringUtils.fromString((String)rankID);
                currentRank = rankUUID != null && this.universe.getPlayer(rankUUID) != null ? this.getPlayerRank(this.universe.getPlayer(rankUUID).getProfile()) : new Rank(this, rankID);
                currentRank.comment = lastComment;
                lastComment = "";
                if (!currentRank.isPlayer()) {
                    if (Ranks.isValidName(currentRank.getId())) {
                        currentRank.add();
                        currentRank.setPermission("power", String.valueOf(this.ranks.size()));
                    } else {
                        currentRank = null;
                        continue;
                    }
                }
                if (extendss.length == 2) {
                    currentRank.setPermission("parent", StringUtils.removeAllWhitespace((String)extendss[1]));
                    save = true;
                }
                if (iss.length != 2) continue;
                for (String tag : iss[1].split(",")) {
                    String s = StringUtils.removeAllWhitespace((String)tag);
                    if (s.isEmpty()) continue;
                    currentRank.setPermission(s, true);
                    save = true;
                }
                continue;
            }
            if (currentRank == null) continue;
            s1 = string.split(":", 2);
            if (s1.length == 2 && !(value = s1[1].trim()).isEmpty() && (entry = currentRank.setPermission(s1[0].trim(), value)) != null) {
                entry.comment = lastComment;
            }
            lastComment = "";
        }
        for (Rank rank : this.playerRanks.values()) {
            if (rank.setPermission("power", "") == null) continue;
            save = true;
        }
        if (save) {
            this.save();
        }
        return true;
    }

    public void save() {
        this.universe.clearCache();
        ArrayList<String> list = new ArrayList<String>();
        list.add("// For more info visit https://github.com/FTBTeam/FTB-Ranks/wiki");
        for (Rank rank : this.ranks.values()) {
            if (rank.permissions.isEmpty()) continue;
            list.add("");
            if (!rank.comment.isEmpty()) {
                list.add("// " + rank.comment);
            }
            list.add("[" + rank.getId() + "]");
            for (Rank.Entry entry : rank.permissions.values()) {
                if (!entry.comment.isEmpty()) {
                    list.add("// " + entry.comment);
                }
                list.add(entry.node + ": " + entry.value);
            }
        }
        FileUtils.saveSafe((File)this.ranksFile, list);
        list = new ArrayList();
        list.add("// For more info visit https://github.com/FTBTeam/FTB-Ranks/wiki");
        for (Rank rank : this.playerRanks.values()) {
            if (rank.permissions.isEmpty()) continue;
            list.add("");
            if (!rank.comment.isEmpty()) {
                list.add("// " + rank.comment);
            }
            list.add("[" + rank.getId() + "]");
            for (Rank.Entry entry : rank.permissions.values()) {
                if (!entry.comment.isEmpty()) {
                    list.add("// " + entry.comment);
                }
                list.add(entry.node + ": " + entry.value);
            }
        }
        FileUtils.saveSafe((File)this.playersFile, list);
    }

    public Rank getRank(MinecraftServer server, ICommandSender sender, String id) throws CommandException {
        if (id.startsWith("@")) {
            return this.getPlayerRank((EntityPlayer)CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)id));
        }
        Rank r = this.getRank(id);
        if (r == null) {
            throw FTBUtilities.error(sender, "commands.ranks.not_found", id);
        }
        return r;
    }

    @Nullable
    public Rank getRank(String id) {
        ForgePlayer player;
        if (id.isEmpty() || id.equals("none")) {
            return null;
        }
        Rank rank = this.ranks.get(id);
        if (rank == null && (player = this.universe.getPlayer((CharSequence)id)) != null) {
            return this.getPlayerRank(player.getProfile());
        }
        return rank;
    }

    @Nullable
    public Rank getDefaultPlayerRank() {
        if (this.defaultPlayerRank == null) {
            for (Rank rank : this.ranks.values()) {
                if (!rank.isDefaultPlayerRank()) continue;
                this.defaultPlayerRank = Optional.of(rank);
                return rank;
            }
            int power = Integer.MAX_VALUE;
            for (Rank rank : this.ranks.values()) {
                if (rank.getPower() > power) continue;
                power = rank.getPower();
                this.defaultPlayerRank = Optional.of(rank);
            }
            if (this.defaultPlayerRank == null) {
                this.defaultPlayerRank = Optional.empty();
            }
        }
        return this.defaultPlayerRank.orElse(null);
    }

    @Nullable
    public Rank getDefaultOPRank() {
        if (this.defaultOPRank == null) {
            for (Rank rank : this.ranks.values()) {
                if (!rank.isDefaultOPRank()) continue;
                this.defaultOPRank = Optional.of(rank);
                return rank;
            }
            int power = 0;
            for (Rank rank : this.ranks.values()) {
                if (rank.getPower() < power) continue;
                power = rank.getPower();
                this.defaultOPRank = Optional.of(rank);
            }
            if (this.defaultOPRank == null) {
                this.defaultOPRank = Optional.empty();
            }
        }
        return this.defaultOPRank.orElse(null);
    }

    public PlayerRank getPlayerRank(GameProfile profile) {
        UUID id = profile.getId();
        if (id == null) {
            throw new NullPointerException("Null UUID in profile " + profile.getName() + "!");
        }
        PlayerRank rank = this.playerRanks.get(id);
        if (rank == null) {
            rank = new PlayerRank(this, id, profile.getName() == null ? "" : profile.getName());
            rank.add();
        }
        return rank;
    }

    public PlayerRank getPlayerRank(EntityPlayer player) {
        return this.getPlayerRank(player.func_146103_bH());
    }

    public ConfigValue getPermission(GameProfile profile, String node, boolean recursive) {
        if (!Ranks.isActive() || profile.getId() == null) {
            return ConfigNull.INSTANCE;
        }
        return this.getPlayerRank(profile).getPermissionValue(node, node, recursive);
    }

    public ConfigValue getPermission(EntityPlayerMP player, String node, boolean recursive) {
        return this.getPermission(player.func_146103_bH(), node, recursive);
    }

    public Event.Result getPermissionResult(GameProfile profile, String node, boolean recursive) {
        ConfigValue value = this.getPermission(profile, node, recursive);
        return value.isNull() ? Event.Result.DEFAULT : (value.getBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
    }

    public Event.Result getPermissionResult(EntityPlayerMP player, String node, boolean recursive) {
        return this.getPermissionResult(player.func_146103_bH(), node, recursive);
    }

    public Collection<String> getPermissionNodes() {
        if (this.permissionNodes == null) {
            this.permissionNodes = new LinkedHashSet<String>();
            for (String s : FTBUtilitiesPermissionHandler.INSTANCE.getRegisteredNodes()) {
                DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(s);
                String desc = DefaultPermissionHandler.INSTANCE.getNodeDescription(s);
                boolean printNode = true;
                for (NodeEntry entry : FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                    if (!s.startsWith(entry.getNode())) continue;
                    if (entry.level == null || level != entry.level || !desc.isEmpty()) break;
                    printNode = false;
                    break;
                }
                if (!printNode) continue;
                this.permissionNodes.add(s);
            }
            for (NodeEntry entry : FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                this.permissionNodes.add(entry.node);
            }
            for (String node : this.commands.keySet()) {
                this.permissionNodes.add(node);
            }
            for (RankConfigValueInfo info : RankConfigAPI.getHandler().getRegisteredConfigs()) {
                this.permissionNodes.add(info.node);
            }
            this.permissionNodes = Arrays.asList(this.permissionNodes.toArray(StringUtils.EMPTY_ARRAY));
        }
        return this.permissionNodes;
    }

    public Collection<String> getRankNames(boolean includeNone) {
        if (!includeNone) {
            return this.ranks.keySet();
        }
        if (this.rankNames == null) {
            this.rankNames = new ArrayList<String>(this.ranks.keySet());
            this.rankNames.add("none");
            this.rankNames = Arrays.asList(this.rankNames.toArray(StringUtils.EMPTY_ARRAY));
        }
        return this.rankNames;
    }

    public void clearCache() {
        this.rankNames = null;
        this.permissionNodes = null;
        this.defaultPlayerRank = null;
        this.defaultOPRank = null;
        for (Rank rank : this.ranks.values()) {
            rank.clearCache();
        }
        for (PlayerRank playerRank : this.playerRanks.values()) {
            playerRank.clearCache();
        }
    }

    static {
        RANK_NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    }
}

