/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.integration.aurora;

import com.feed_the_beast.ftbutilities.ranks.CommandOverride;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import dev.latvian.mods.aurora.page.HTTPWebPage;
import dev.latvian.mods.aurora.tag.Style;
import dev.latvian.mods.aurora.tag.Tag;
import net.minecraft.server.MinecraftServer;

public class CommandListPage
extends HTTPWebPage {
    private final MinecraftServer server;

    public CommandListPage(MinecraftServer s) {
        this.server = s;
    }

    public String getTitle() {
        return "FTB Utilities";
    }

    public String getDescription() {
        return "Command List";
    }

    public String getIcon() {
        return "https://i.imgur.com/aIuCGYZ.png";
    }

    public void head(Tag head) {
        super.head(head);
        Style s = head.style();
        s.add("p").set("margin", "0");
    }

    public void body(Tag body) {
        body.h1("Command List");
        Tag nodeTable = body.table();
        Tag firstRow = nodeTable.tr();
        firstRow.th().text((Object)"Available command nodes");
        firstRow.th().text((Object)"Usage");
        for (CommandOverride c : Ranks.INSTANCE.commands.values()) {
            Tag row = nodeTable.tr();
            row.td().paired("code", c.node.toString());
            Tag n = row.td();
            boolean first = true;
            for (String s : Tag.fixHTML((String)c.usage.func_150260_c()).split(" OR ")) {
                if (first) {
                    first = false;
                } else {
                    n.br();
                }
                n.text((Object)s);
            }
        }
    }
}

