/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftbutilities.data.Leaderboard;
import com.feed_the_beast.ftbutilities.events.LeaderboardRegistryEvent;
import java.util.Comparator;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesLeaderboards {
    @SubscribeEvent
    public static void registerLeaderboards(LeaderboardRegistryEvent event) {
        event.register(new Leaderboard.FromStat(new ResourceLocation("ftbutilities", "deaths"), StatList.field_188069_A, false, Leaderboard.FromStat.DEFAULT));
        event.register(new Leaderboard.FromStat(new ResourceLocation("ftbutilities", "mob_kills"), StatList.field_188070_B, false, Leaderboard.FromStat.DEFAULT));
        event.register(new Leaderboard.FromStat(new ResourceLocation("ftbutilities", "time_played"), StatList.field_188097_g, false, Leaderboard.FromStat.TIME));
        event.register(new Leaderboard.FromStat(new ResourceLocation("ftbutilities", "jumps"), StatList.field_75953_u, false, Leaderboard.FromStat.DEFAULT));
        event.register(new Leaderboard(new ResourceLocation("ftbutilities", "deaths_per_hour"), (ITextComponent)new TextComponentTranslation("ftbutilities.stat.dph", new Object[0]), player -> {
            double d = FTBUtilitiesLeaderboards.getDPH(player);
            return new TextComponentString(d < 0.0 ? "-" : String.format("%.2f", d));
        }, Comparator.comparingDouble(FTBUtilitiesLeaderboards::getDPH).reversed(), player -> FTBUtilitiesLeaderboards.getDPH(player) >= 0.0));
        event.register(new Leaderboard(new ResourceLocation("ftbutilities", "last_seen"), (ITextComponent)new TextComponentTranslation("ftbutilities.stat.last_seen", new Object[0]), player -> {
            if (player.isOnline()) {
                TextComponentTranslation component = new TextComponentTranslation("gui.online", new Object[0]);
                component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                return component;
            }
            long worldTime = player.team.universe.world.func_82737_E();
            int time = (int)(worldTime - player.getLastTimeSeen());
            return Leaderboard.FromStat.TIME.apply(time);
        }, Comparator.comparingLong(FTBUtilitiesLeaderboards::getRelativeLastSeen), player -> player.getLastTimeSeen() != 0L));
    }

    private static long getRelativeLastSeen(ForgePlayer player) {
        if (player.isOnline()) {
            return 0L;
        }
        return player.team.universe.ticks.ticks() - player.getLastTimeSeen();
    }

    private static double getDPH(ForgePlayer player) {
        double hours;
        int playTime = player.stats().func_77444_a(StatList.field_188097_g);
        if (playTime > 0 && (hours = Ticks.get((long)playTime).hoursd()) >= 1.0) {
            return (double)player.stats().func_77444_a(StatList.field_188069_A) / hours;
        }
        return -1.0;
    }
}

