/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.io;

import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.imageio.ImageIO;

public class FileDataReader
extends DataReader {
    public final File file;

    FileDataReader(File f) {
        this.file = f;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean canRead() {
        return this.file.exists() && this.file.isFile() && this.file.canRead();
    }

    private void checkFile() throws Exception {
        if (!this.canRead()) {
            throw new FileNotFoundException("File is not found/readable!");
        }
    }

    @Override
    public String string() throws Exception {
        return this.string(1024);
    }

    @Override
    public String string(int bufferSize) throws Exception {
        this.checkFile();
        try (FileInputStream stream = new FileInputStream(this.file);){
            String string = FileDataReader.readStringFromStream(stream, bufferSize);
            return string;
        }
    }

    @Override
    public List<String> stringList() throws Exception {
        this.checkFile();
        try (FileInputStream stream = new FileInputStream(this.file);){
            List<String> list = FileDataReader.readStringListFromStream(stream);
            return list;
        }
    }

    @Override
    public JsonElement json() throws Exception {
        this.checkFile();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));){
            JsonElement jsonElement = JsonUtils.parse(reader);
            return jsonElement;
        }
    }

    @Override
    public BufferedImage image() throws Exception {
        this.checkFile();
        return ImageIO.read(this.file);
    }
}

