/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public abstract class CmdEditConfigBase
extends CmdBase {
    public CmdEditConfigBase(String n, CmdBase.Level l) {
        super(n, l);
    }

    public abstract ConfigGroup getGroup(ICommandSender var1) throws CommandException;

    public IConfigCallback getCallback(ICommandSender sender) throws CommandException {
        return IConfigCallback.DEFAULT;
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        try {
            ConfigGroup group = this.getGroup(sender);
            if (args.length == 1) {
                List keys = CmdEditConfigBase.func_175762_a((String[])args, group.getValueKeyTree());
                if (keys.size() > 1) {
                    keys.sort(StringUtils.ID_COMPARATOR);
                }
                return keys;
            }
            if (args.length == 2) {
                List<String> variants;
                ConfigValue value = group.getValue(args[0]);
                if (!value.isNull() && !(variants = value.getVariants()).isEmpty()) {
                    return CmdEditConfigBase.func_175762_a((String[])args, variants);
                }
                return Collections.emptyList();
            }
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 && sender instanceof EntityPlayerMP) {
            FTBLibAPI.editServerConfig(CmdEditConfigBase.func_71521_c((ICommandSender)sender), this.getGroup(sender), this.getCallback(sender));
            return;
        }
        this.checkArgs(sender, args, 1);
        ConfigGroup group = this.getGroup(sender);
        ConfigValueInstance instance = group.getValueInstance(args[0]);
        if (instance == null) {
            throw FTBLib.error(sender, "ftblib.lang.config_command.invalid_key", args[0]);
        }
        if (args.length >= 2) {
            String valueString = String.valueOf(StringUtils.joinSpaceUntilEnd(1, args));
            if (!instance.getValue().setValueFromString(sender, valueString, true)) {
                return;
            }
            if (FTBLibConfig.debugging.log_config_editing) {
                FTBLib.LOGGER.info("Setting " + instance.getPath() + " to " + valueString);
            }
            instance.getValue().setValueFromString(sender, valueString, false);
            this.getCallback(sender).onConfigSaved(group, sender);
            Notification.of(Notification.VANILLA_STATUS, FTBLib.lang(sender, "ftblib.lang.config_command.set", instance.getDisplayName(), group.getValue(args[0]).toString())).send(server, (EntityPlayer)CmdEditConfigBase.func_71521_c((ICommandSender)sender));
        }
        sender.func_145747_a(instance.getValue().getStringForGUI());
    }
}

