/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import pl.asie.foamfix.coremod.FoamFixTransformer;
import pl.asie.foamfix.shared.FoamFixShared;

@IFMLLoadingPlugin.Name(value="Do not report to Forge! (If you haven't disabled the FoamFix coremod, try disabling it in the config! Note that this bit of text will still appear.)")
@IFMLLoadingPlugin.SortingIndex(value=1001)
@IFMLLoadingPlugin.TransformerExclusions(value={"pl.asie.foamfix"})
public class FoamFixCore
implements IFMLLoadingPlugin {
    public String[] getASMTransformerClass() {
        return new String[]{"pl.asie.foamfix.coremod.FoamFixTransformer"};
    }

    public String getModContainerClass() {
        return "pl.asie.foamfix.coremod.FoamFixCoreContainer";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        FoamFixShared.config.init(new File(new File("config"), "foamfix.cfg"), true);
        if (FoamFixShared.isCoremod) {
            if (FoamFixShared.config.clInitOptions) {
                try {
                    File forgeCfgFile;
                    File optionsFile = new File("options.txt");
                    if (!optionsFile.exists()) {
                        Files.write((CharSequence)"mipmapLevels:0\n", (File)optionsFile, (Charset)Charsets.UTF_8);
                    }
                    if (!(forgeCfgFile = new File(new File("config"), "forge.cfg")).exists()) {
                        Files.write((CharSequence)"client {\nB:alwaysSetupTerrainOffThread=true\n}\n", (File)forgeCfgFile, (Charset)Charsets.UTF_8);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.getClass().getClassLoader() instanceof LaunchClassLoader) {
                if (FoamFixShared.config.geBlacklistLibraryTransformers) {
                    LaunchClassLoader classLoader = (LaunchClassLoader)this.getClass().getClassLoader();
                    classLoader.addTransformerExclusion("com.ibm.icu.");
                    classLoader.addTransformerExclusion("com.sun.");
                    classLoader.addTransformerExclusion("gnu.trove.");
                    classLoader.addTransformerExclusion("io.netty.");
                    classLoader.addTransformerExclusion("it.unimi.dsi.fastutil.");
                    classLoader.addTransformerExclusion("joptsimple.");
                    classLoader.addTransformerExclusion("org.apache.");
                    classLoader.addTransformerExclusion("oshi.");
                    classLoader.addTransformerExclusion("scala.");
                }
                LaunchClassLoader launchClassLoader = (LaunchClassLoader)this.getClass().getClassLoader();
            }
            FoamFixTransformer.init();
        }
    }

    public String getAccessTransformerClass() {
        return "pl.asie.foamfix.coremod.FoamFixAT";
    }
}

