/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import fluxnetworks.FluxNetworks;
import fluxnetworks.api.gui.EnumFeedbackInfo;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.network.NetworkSettings;
import fluxnetworks.api.utils.FluxConfigurationType;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.item.ItemConfigurator;
import fluxnetworks.common.network.PacketFeedback;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetConfiguratorNetwork
implements IMessageHandler<SetConfiguratorNetworkMessage, IMessage> {
    public IMessage onMessage(SetConfiguratorNetworkMessage message, MessageContext ctx) {
        EntityPlayer player = FluxNetworks.proxy.getPlayer(ctx);
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(message.id);
        if (!network.isInvalid()) {
            ItemStack stack;
            if (!network.getMemberPermission(player).canAccess()) {
                if (message.password.isEmpty()) {
                    return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.PASSWORD_REQUIRE);
                }
                if (!message.password.equals(network.getSetting(NetworkSettings.NETWORK_PASSWORD))) {
                    return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.REJECT);
                }
            }
            if ((stack = player.func_184614_ca()).func_77973_b() instanceof ItemConfigurator) {
                NBTTagCompound configs = stack.func_190925_c("Configs");
                configs.func_74768_a(FluxConfigurationType.NETWORK.getNBTName(), message.id);
            }
            return new PacketFeedback.FeedbackMessage(EnumFeedbackInfo.SUCCESS);
        }
        return null;
    }

    public static class SetConfiguratorNetworkMessage
    implements IMessage {
        public int id;
        public String password;

        public SetConfiguratorNetworkMessage() {
        }

        public SetConfiguratorNetworkMessage(int id, String password) {
            this.id = id;
            this.password = password;
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.password = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.password);
        }
    }
}

