/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.handler.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketConnectionUpdate
implements IMessageHandler<NetworkConnectionMessage, IMessage> {
    public IMessage onMessage(NetworkConnectionMessage message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            PacketHandler.handlePacket(() -> FluxNetworkCache.instance.updateClientConnections(message.networkID, message.tags), ctx.netHandler);
        }
        return null;
    }

    public static class NetworkConnectionMessage
    implements IMessage {
        public int networkID;
        public List<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();

        public NetworkConnectionMessage() {
        }

        public NetworkConnectionMessage(int networkID, List<NBTTagCompound> tags) {
            this.networkID = networkID;
            this.tags = tags;
        }

        public void fromBytes(ByteBuf buf) {
            this.networkID = buf.readInt();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.tags.add(ByteBufUtils.readTag((ByteBuf)buf));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.networkID);
            buf.writeInt(this.tags.size());
            this.tags.forEach(t -> ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)t));
        }
    }
}

