/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.handler.energy;

import fluxnetworks.api.energy.IItemEnergyHandler;
import fluxnetworks.api.energy.ITileEnergyHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import ic2.api.tile.IEnergyStorage;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class IC2EnergyHandler
implements ITileEnergyHandler,
IItemEnergyHandler {
    public static final IC2EnergyHandler INSTANCE = new IC2EnergyHandler();

    @Override
    public boolean canRenderConnection(@Nonnull TileEntity tile, EnumFacing side) {
        return tile instanceof IEnergyTile || tile instanceof IEnergyStorage;
    }

    @Override
    public boolean canAddEnergy(TileEntity tile, EnumFacing side) {
        return tile instanceof IEnergySink || tile instanceof IEnergyStorage;
    }

    @Override
    public boolean canRemoveEnergy(TileEntity tile, EnumFacing side) {
        return false;
    }

    @Override
    public long addEnergy(long amount, TileEntity tile, EnumFacing side, boolean simulate) {
        if (tile instanceof IEnergyStorage) {
            IEnergyStorage sink = (IEnergyStorage)tile;
            int before = sink.getStored();
            if (!simulate) {
                return sink.addEnergy((int)Math.min((long)(sink.getCapacity() - before), amount >> 2)) << 2;
            }
            return Math.min((long)(sink.getCapacity() - before), amount >> 2) << 2;
        }
        if (tile instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)tile;
            double voltage = EnergyNet.instance.getPowerFromTier(sink.getSinkTier());
            double a = Math.min((double)(amount >> 2), voltage);
            if (simulate) {
                return (long)Math.min(a, sink.getDemandedEnergy()) << 2;
            }
            return (long)Math.floor(a - sink.injectEnergy(side, a, voltage)) << 2;
        }
        return 0L;
    }

    @Override
    public long removeEnergy(long amount, TileEntity tile, EnumFacing side) {
        return 0L;
    }

    @Override
    public boolean canAddEnergy(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof IElectricItem || stack.func_77973_b() instanceof ISpecialElectricItem);
    }

    @Override
    public boolean canRemoveEnergy(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof IElectricItem || stack.func_77973_b() instanceof ISpecialElectricItem);
    }

    @Override
    public long addEnergy(long amount, ItemStack stack, boolean simulate) {
        IElectricItemManager manager = IC2EnergyHandler.getManager(stack);
        return (long)manager.charge(stack, (double)(amount >> 2), 4, false, simulate) << 2;
    }

    @Override
    public long removeEnergy(long amount, ItemStack stack) {
        IElectricItemManager manager = IC2EnergyHandler.getManager(stack);
        return (long)manager.discharge(stack, (double)(amount >> 2), 4, false, true, false) << 2;
    }

    public static IElectricItemManager getManager(ItemStack stack) {
        if (stack.func_77973_b() instanceof ISpecialElectricItem) {
            IElectricItemManager manager = ((ISpecialElectricItem)stack.func_77973_b()).getManager(stack);
            if (manager == null) {
                manager = ElectricItem.getBackupManager((ItemStack)stack);
            }
            return manager;
        }
        return ElectricItem.manager;
    }
}

