/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection.transfer;

import fluxnetworks.api.energy.ITileEnergyHandler;
import fluxnetworks.api.network.IFluxTransfer;
import fluxnetworks.api.network.ISidedTransfer;
import fluxnetworks.api.network.ITransferHandler;
import fluxnetworks.common.core.FluxUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class ConnectionTransfer
implements IFluxTransfer,
ISidedTransfer {
    public final ITransferHandler transferHandler;
    public final ITileEnergyHandler energyHandler;
    public final TileEntity tile;
    public final EnumFacing side;
    public final ItemStack displayStack;
    public long added;
    public long removed;

    public ConnectionTransfer(ITransferHandler transferHandler, ITileEnergyHandler energyHandler, TileEntity tile, EnumFacing side) {
        this.transferHandler = transferHandler;
        this.energyHandler = energyHandler;
        this.tile = tile;
        this.side = side;
        this.displayStack = FluxUtils.getBlockItem(tile.func_145831_w(), tile.func_174877_v());
    }

    @Override
    public long addToNetwork(long amount, boolean simulate) {
        return 0L;
    }

    @Override
    public long removeFromNetwork(long amount, boolean simulate) {
        EnumFacing dir = this.side.func_176734_d();
        if (this.energyHandler.canAddEnergy(this.tile, dir)) {
            long added = this.energyHandler.addEnergy(amount, this.tile, dir, simulate);
            if (!simulate) {
                this.removedFromNetwork(added);
            }
            return added;
        }
        return 0L;
    }

    @Override
    public void addedToNetwork(long amount) {
        this.added += amount;
    }

    @Override
    public void removedFromNetwork(long amount) {
        this.removed += amount;
    }

    @Override
    public void onServerStartTick() {
        this.added = 0L;
        this.removed = 0L;
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public EnumFacing getSide() {
        return this.side;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    @Override
    public boolean isInvalid() {
        return this.tile.func_145837_r();
    }
}

