/*
 * Decompiled with CFR 0.152.
 */
package net.yseven.findyourway.Client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.yseven.findyourway.CommonProxy;
import net.yseven.findyourway.Network.MessageHandlerOnClient;
import net.yseven.findyourway.Network.MessageToClient;
import net.yseven.findyourway.Network.MessageToServer;
import net.yseven.findyourway.item.ItemCompassBase;
import net.yseven.findyourway.item.ModItems;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static boolean angleError = false;

    public static Minecraft getMinecraft() {
        return FMLClientHandler.instance().getClient();
    }

    public static WorldClient getWorld() {
        return ClientProxy.getMinecraft().field_71441_e;
    }

    public static EntityPlayerSP getPlayer() {
        return ClientProxy.getMinecraft().field_71439_g;
    }

    public static boolean hasAngleErrrored() {
        return angleError;
    }

    public static void AngleHasErrored() {
        angleError = true;
    }

    public static boolean hasCompass(ItemCompassBase compass) {
        return ClientProxy.getPlayer() != null && CommonProxy.containsCompass((IInventory)ClientProxy.getPlayer().field_71071_by, compass);
    }

    public static void resetStructurePos(ItemCompassBase compass) {
        compass.setStructurePos(null);
        compass.setStructureWorld((World)ClientProxy.getWorld());
        CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessageToServer(compass));
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        CommonProxy.simpleNetworkWrapper.registerMessage(MessageHandlerOnClient.class, MessageToClient.class, 72, Side.CLIENT);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModItems.registerModels();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        for (int i = 0; i < CommonProxy.compassList.size(); ++i) {
            if (!ClientProxy.hasCompass(CommonProxy.compassList.get(i)) || ClientProxy.getWorld() == CommonProxy.compassList.get(i).getStructureWorld()) continue;
            ClientProxy.resetStructurePos(CommonProxy.compassList.get(i));
        }
    }
}

