/*
 * Decompiled with CFR 0.152.
 */
package net.yseven.findyourway.Client;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.yseven.findyourway.Client.ClientProxy;
import net.yseven.findyourway.CommonProxy;

public class AngleGetter
implements IItemPropertyGetter {
    @SideOnly(value=Side.CLIENT)
    private double prevAngle = 0.0;
    @SideOnly(value=Side.CLIENT)
    private double prevWobble = 0.0;
    @SideOnly(value=Side.CLIENT)
    private long prevWorldTime = 0L;
    @SideOnly(value=Side.CLIENT)
    private BlockPos blockPos;

    @ParametersAreNonnullByDefault
    @SideOnly(value=Side.CLIENT)
    public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
        double angle;
        boolean isLiving = entityIn != null;
        EntityChicken errorChicken = new EntityChicken((World)Minecraft.func_71410_x().field_71441_e);
        Object entity = isLiving ? entityIn : (stack.func_82836_z() != null ? stack.func_82836_z() : errorChicken);
        if (worldIn == null) {
            worldIn = entity.field_70170_p;
        }
        this.setBlockPos(stack);
        if (this.blockPos != null) {
            double entityAngle;
            if (this.blockPos.func_177956_o() == 0) {
                return 0.0f;
            }
            if (isLiving) {
                entityAngle = entity.field_70177_z;
            } else if (stack.func_82836_z() != null) {
                entityAngle = this.getFrameAngle((EntityItemFrame)entity);
            } else {
                return 0.0f;
            }
            entityAngle /= 360.0;
            entityAngle = MathHelper.func_191273_b((double)entityAngle, (double)1.0);
            double posAngle = this.getAngle(this.blockPos, (Entity)entity);
            angle = 0.5 - (entityAngle - 0.25 - (posAngle /= Math.PI * 2));
        } else {
            if (!ClientProxy.hasAngleErrrored()) {
                System.out.println("Compass angle is random due to an unexpected error");
                ClientProxy.AngleHasErrored();
            }
            angle = 0.0;
        }
        if (isLiving) {
            angle = this.wobble(worldIn, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private double wobble(World world, double angle) {
        long worldTime = world.func_82737_E();
        if (worldTime != this.prevWorldTime) {
            this.prevWorldTime = worldTime;
            double angleDifference = angle - this.prevAngle;
            angleDifference = MathHelper.func_191273_b((double)(angleDifference + 0.5), (double)1.0) - 0.5;
            this.prevWobble += angleDifference * 0.1;
            this.prevWobble *= 0.8;
            this.prevAngle = MathHelper.func_191273_b((double)(this.prevAngle + this.prevWobble), (double)1.0);
        }
        return this.prevAngle;
    }

    @SideOnly(value=Side.CLIENT)
    private void setBlockPos(ItemStack stack) {
        for (int i = 0; i < CommonProxy.compassList.size(); ++i) {
            if (stack.func_77973_b().func_77658_a().equals(CommonProxy.compassList.get(i).func_77658_a())) {
                this.blockPos = CommonProxy.compassList.get(i).getStructurePos();
                continue;
            }
            if (ClientProxy.hasAngleErrrored()) continue;
            System.out.println("unable to get blockPos from compassList in AngleGetter class");
        }
    }

    @SideOnly(value=Side.CLIENT)
    private double getAngle(BlockPos pos, Entity ent) {
        return MathHelper.func_181159_b((double)((double)pos.func_177952_p() - ent.field_70161_v), (double)((double)pos.func_177958_n() - ent.field_70165_t));
    }

    @SideOnly(value=Side.CLIENT)
    private double getFrameAngle(EntityItemFrame entity) {
        return MathHelper.func_188209_b((int)(180 + entity.field_174860_b.func_176736_b() * 90));
    }
}

