/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import gnu.trove.list.TLinkable;
import gnu.trove.list.linked.TLinkedList;
import gnu.trove.set.hash.THashSet;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class WeakLinkedSet<E>
extends AbstractSet<E> {
    private final ReferenceQueue<E> queue = new ReferenceQueue();
    private WeakLinkTHashSet set = new WeakLinkTHashSet();
    private TLinkedList<WeakLink<E>> order = new TLinkedList();

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        this.expungeStaleEntries();
        return new Iter();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.set.size();
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        this.set.clear();
        this.order.clear();
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean contains(Object o) {
        this.expungeStaleEntries();
        return this.set.contains(o);
    }

    @Override
    public boolean add(E e) {
        this.expungeStaleEntries();
        if (this.set.contains(e)) {
            return false;
        }
        WeakLink<E> link = new WeakLink<E>(e, this.queue);
        if (this.set.add(link)) {
            this.order.add(link);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        this.expungeStaleEntries();
        WeakLink weakLink = this.set.removeSpecial(o);
        if (weakLink != null) {
            this.order.remove((Object)weakLink);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<E> poll;
        while ((poll = this.queue.poll()) != null) {
            ReferenceQueue<E> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                WeakLink entry2 = (WeakLink)poll;
                entry2.fallbackNext = entry2.next;
                this.set.remove(entry2);
                this.order.remove((Object)entry2);
            }
        }
    }

    private class Iter
    implements Iterator<E> {
        private WeakLink<E> entry;
        private WeakLink<E> lastReturned;
        private E nextKey;
        private E curKey;

        private Iter() {
            this.entry = (WeakLink)WeakLinkedSet.this.order.getFirst();
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            while (this.nextKey == null) {
                if (this.entry == null) {
                    this.curKey = null;
                    return false;
                }
                this.nextKey = this.entry.get();
                if (this.nextKey != null) {
                    return true;
                }
                WeakLink next = this.entry.next;
                if (next == null) {
                    this.entry = this.entry.fallbackNext;
                    continue;
                }
                this.entry = next;
            }
            return true;
        }

        @Override
        public E next() {
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.curKey = this.nextKey;
            this.nextKey = null;
            return this.curKey;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            WeakLinkedSet.this.order.remove(this.lastReturned);
            WeakLinkedSet.this.set.remove(this.lastReturned);
            this.lastReturned = null;
            this.curKey = null;
        }
    }

    private class WeakLinkTHashSet
    extends THashSet<WeakLink<E>> {
        public WeakLink removeSpecial(Object obj) {
            int index = this.index(obj);
            if (index >= 0) {
                Object o = this._set[index];
                this.removeAt(index);
                return (WeakLink)o;
            }
            return null;
        }

        protected int hash(Object notnull) {
            if (notnull instanceof WeakLink) {
                return notnull.hashCode();
            }
            return System.identityHashCode(notnull);
        }

        protected boolean equals(Object notnull, Object two) {
            return two != null && two != REMOVED && two.equals(notnull);
        }
    }

    public static class WeakLink<E>
    extends WeakReference<E>
    implements TLinkable<WeakLink<E>> {
        final int hash;
        WeakLink<E> next;
        WeakLink<E> previous;
        WeakLink<E> fallbackNext;

        public WeakLink(E referent, ReferenceQueue<E> queue) {
            super(referent, queue);
            this.hash = System.identityHashCode(referent);
        }

        public WeakLink<E> getNext() {
            return this.next;
        }

        public void setNext(WeakLink<E> next) {
            this.next = next;
        }

        public WeakLink<E> getPrevious() {
            return this.previous;
        }

        public void setPrevious(WeakLink<E> previous) {
            this.previous = previous;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Object e1 = this.get();
            if (e1 == null) {
                return false;
            }
            if (e1 == obj) {
                return true;
            }
            if (obj.getClass() == WeakLink.class) {
                WeakLink other = (WeakLink)obj;
                Object e2 = other.get();
                return e2 != null && e1 == e2;
            }
            return false;
        }
    }
}

