/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class IterableConcatBuilder<E> {
    List<E> backupIterable = null;
    List<Iterable<? extends E>> iterables = new ArrayList<Iterable<? extends E>>();

    private List<E> initBackup() {
        if (this.backupIterable == null) {
            this.backupIterable = new ArrayList();
            this.iterables.add(this.backupIterable);
        }
        return this.backupIterable;
    }

    public IterableConcatBuilder<E> add(E element) {
        this.initBackup().add(element);
        return this;
    }

    public IterableConcatBuilder<E> addAll(Iterable<? extends E> elements) {
        this.iterables.add(elements);
        return this;
    }

    public IterableConcatBuilder<E> addArray(E ... elements) {
        Collections.addAll(this.initBackup(), elements);
        return this;
    }

    public IterableConcatBuilder<E> addAll(Iterator<? extends E> elements) {
        this.iterables.add(Lists.newArrayList(elements));
        return this;
    }

    public IterableConcatBuilder<E> combine(IterableConcatBuilder<E> other) {
        if (other.backupIterable != null) {
            if (this.backupIterable == null) {
                this.backupIterable = other.backupIterable;
            } else {
                this.backupIterable.addAll(other.backupIterable);
            }
        }
        this.iterables.addAll(other.iterables);
        return this;
    }

    public Iterable<E> build() {
        return Iterables.concat(this.iterables);
    }
}

