/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tweaker;

import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.tweaker.CrafttweakerMachineRecipe;
import com.rwtema.extrautils2.tweaker.IMachineSlot;
import com.rwtema.extrautils2.tweaker.ObjWrapper;
import com.rwtema.extrautils2.tweaker.XUTweaker;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.liquid.WeightedLiquidStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="extrautilities2.Tweaker.IMachine")
@ZenRegister
public class IMachine
extends ObjWrapper<Machine> {
    public IMachine(Machine object) {
        super(object);
    }

    @ZenMethod
    public void addRecipe(Map<String, IIngredient> inputs, Map<String, Object> outputs, int energy, int time) {
        HashMap<String, IIngredient> outMap = new HashMap<String, IIngredient>();
        HashMap<String, Float> probMap = new HashMap<String, Float>();
        outputs.forEach((slot, obj) -> {
            if (obj instanceof WeightedItemStack) {
                probMap.put((String)slot, Float.valueOf(((WeightedItemStack)obj).getChance()));
                outMap.put((String)slot, (IIngredient)((WeightedItemStack)obj).getStack());
            } else if (obj instanceof WeightedLiquidStack) {
                probMap.put((String)slot, Float.valueOf(((WeightedLiquidStack)obj).getChance()));
                outMap.put((String)slot, (IIngredient)((WeightedLiquidStack)obj).getStack());
            } else if (obj instanceof IIngredient) {
                outMap.put((String)slot, (IIngredient)obj);
            }
        });
        this.addRecipe(inputs, outMap, energy, time, probMap);
    }

    @ZenMethod
    public void addRecipe(Map<String, IIngredient> inputs, Map<String, IIngredient> outputs, int energy, int time, Map<String, Float> probabilities) {
        CrafttweakerMachineRecipe recipe = new CrafttweakerMachineRecipe((Machine)this.getInternal(), inputs, outputs, probabilities, energy, time);
        ((Machine)this.getInternal()).recipes_registry.addRecipe(recipe);
    }

    @ZenMethod
    public void removeRecipe(Map<String, IIngredient> inputs) {
        HashMap<String, IItemStack> items = new HashMap<String, IItemStack>();
        HashMap<String, ILiquidStack> fluids = new HashMap<String, ILiquidStack>();
        inputs.forEach((s, ingredient) -> {
            List items1;
            List liquids = ingredient.getLiquids();
            if (liquids != null && !liquids.isEmpty()) {
                fluids.put((String)s, (ILiquidStack)liquids.iterator().next());
            }
            if ((items1 = ingredient.getItems()) != null && !items1.isEmpty()) {
                items.put((String)s, (IItemStack)items1.iterator().next());
            }
        });
        this.removeRecipe(items, fluids);
    }

    @ZenMethod
    public void removeRecipe(Map<String, IItemStack> items, Map<String, ILiquidStack> fluids) {
        Map<MachineSlotItem, ItemStack> itemMap = items.entrySet().stream().collect(Collectors.toMap(s -> ((Machine)this.object).itemInputs.stream().filter(t -> ((String)s.getKey()).equals(t.name)).findFirst().orElse(null), s -> XUTweaker.createItemStack((IItemStack)s.getValue())));
        Map<MachineSlotFluid, FluidStack> fluidMap = fluids.entrySet().stream().collect(Collectors.toMap(s -> ((Machine)this.object).fluidInputs.stream().filter(t -> ((String)s.getKey()).equals(t.name)).findFirst().orElse(null), s -> XUTweaker.createFluidStack((ILiquidStack)s.getValue())));
        for (IMachineRecipe recipe : ((Machine)this.object).recipes_registry) {
            if (!recipe.matches(itemMap, fluidMap)) continue;
            ((Machine)this.object).recipes_registry.removeRecipe(recipe);
            break;
        }
    }

    @ZenMethod
    public List<IMachineSlot> getInputSlots() {
        return Stream.concat(((Machine)this.object).itemInputs.stream(), ((Machine)this.object).fluidInputs.stream()).map(IMachineSlot::new).collect(Collectors.toList());
    }

    @ZenMethod
    public List<IMachineSlot> getOutputSlots() {
        return Stream.concat(((Machine)this.object).itemOutputs.stream(), ((Machine)this.object).fluidOutputs.stream()).map(IMachineSlot::new).collect(Collectors.toList());
    }

    @ZenMethod
    public IMachineSlot getSlot(String slotName) {
        for (MachineSlot slot : ((Machine)this.object).itemInputs) {
            if (!slot.name.equals(slotName)) continue;
            return new IMachineSlot(slot);
        }
        for (MachineSlot slot : ((Machine)this.object).itemOutputs) {
            if (!slot.name.equals(slotName)) continue;
            return new IMachineSlot(slot);
        }
        for (MachineSlot slot : ((Machine)this.object).fluidInputs) {
            if (!slot.name.equals(slotName)) continue;
            return new IMachineSlot(slot);
        }
        for (MachineSlot slot : ((Machine)this.object).fluidOutputs) {
            if (!slot.name.equals(slotName)) continue;
            return new IMachineSlot(slot);
        }
        return null;
    }
}

