/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TileTrashCan
extends XUTile
implements IDynamicHandler {
    SingleStackHandlerFilter.ItemFilter FILTER = this.registerNBT("filter", new SingleStackHandlerFilter.ItemFilter());
    IItemHandler ABSORB_HANDLER = new IItemHandlerModifiableCompat(){

        @Override
        public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
        }

        @Override
        public int getSlots() {
            return 32;
        }

        @Override
        @ItemStackNonNull
        public ItemStack getStackInSlot(int slot) {
            return StackHelper.empty();
        }

        @Override
        @ItemStackNonNull
        public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
            return StackHelper.isNull(stack) || TileTrashCan.this.FILTER.isEmpty() || TileTrashCan.this.FILTER.matches(stack) ? StackHelper.empty() : stack;
        }

        @Override
        @ItemStackNonNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return StackHelper.empty();
        }
    };

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return InventoryHelper.getItemHandlerIterator((IItemHandler)this.FILTER);
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.ABSORB_HANDLER;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerTrashCan(player);
    }

    public class ContainerTrashCan
    extends DynamicContainerTile {
        public ContainerTrashCan(EntityPlayer player) {
            super(TileTrashCan.this, 16, 64);
            this.addTitle(Lang.getItemName(TileTrashCan.this.getXUBlock()), false);
            this.addWidget(TileTrashCan.this.FILTER.newSlot(144, 40));
            this.addWidget(new WidgetSlotItemHandler(TileTrashCan.this.ABSORB_HANDLER, 0, 76, 40));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

