/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.fluids.FluidTankSerial;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class TileDrum
extends XUTile
implements ITickable {
    public static int numTicksTilDisplayEmpty = 40;
    public FluidStack prevFluid = null;
    boolean recentlyFilled = false;
    boolean recentlyDrained = false;
    public FluidTankSerial tanks = this.registerNBT("tank", new FluidTankSerial(this.getCapacity()){

        @Override
        protected void onChange() {
            TileDrum.this.func_70296_d();
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            boolean t2 = this.getFluid() == null;
            int t = 0;
            if (this.getCapacity() == this.getFluidAmount()) {
                TileEntity up = TileDrum.this.field_145850_b.func_175625_s(TileDrum.this.field_174879_c.func_177982_a(0, 1, 0));
                if (up != null && up instanceof TileDrum) {
                    TileDrum upDrum = (TileDrum)up;
                    if (upDrum.tanks.getFluidAmount() == 0 || upDrum.tanks.getFluid().isFluidEqual(resource)) {
                        t = upDrum.tanks.fill(resource, doFill);
                    }
                }
            } else {
                t = super.fill(resource, doFill);
                if (doFill) {
                    if (t2 && this.getFluid() != null && !this.getFluid().isFluidEqual(TileDrum.this.prevFluid)) {
                        TileDrum.this.prevFluid = this.getFluid().copy();
                        TileDrum.this.markForUpdate();
                    }
                    if (t != 0) {
                        TileDrum.this.recentlyFilled = true;
                    }
                }
            }
            return t;
        }

        @Override
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || !resource.isFluidEqual(this.getFluid())) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        @Override
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack t = super.drain(maxDrain, doDrain);
            if (doDrain && t != null && this.getFluidAmount() == 0) {
                TileDrum.this.recentlyDrained = true;
                TileDrum.this.scheduleUpdate();
            }
            return t;
        }
    });
    private boolean empty = false;
    private boolean hasFluid = false;
    private int delayTicks;

    public static FluidStack getFluidFromItemStack(ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return null;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Fluid")) {
            return null;
        }
        NBTTagCompound fluidNBT = tagCompound.func_74775_l("Fluid");
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidNBT);
    }

    protected abstract int getCapacity();

    public void ticked() {
        if (this.recentlyDrained) {
            this.recentlyDrained = false;
            if (this.recentlyFilled) {
                this.recentlyFilled = false;
                this.scheduleUpdate();
            } else {
                this.func_70296_d();
                this.markForUpdate();
            }
        }
    }

    public void scheduleUpdate() {
        this.field_145850_b.func_180497_b(this.func_174877_v(), this.func_145838_q(), numTicksTilDisplayEmpty, 0);
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (this.handleFluids(worldIn, playerIn, hand, heldItem, side)) {
            return true;
        }
        return true;
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        FluidStack oldFluid;
        FluidStack fluid = packet.readFluidStack();
        if (!(fluid == (oldFluid = this.tanks.getFluid()) || fluid != null && fluid.isFluidEqual(oldFluid))) {
            this.markForUpdate();
        }
        this.tanks.setFluid(fluid);
    }

    @Override
    public boolean harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, XUBlock xuBlock, IBlockState state) {
        if (this.tanks.isEmpty()) {
            return false;
        }
        ItemStack itemStack = this.createDropStack((XUBlockState)state);
        Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
        return true;
    }

    @Override
    public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
        return Optional.of(this.createDropStack());
    }

    public ItemStack createDropStack() {
        return this.createDropStack(this.getBlockState());
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        FluidStack fluidStack = TileDrum.getFluidFromItemStack(stack);
        if (fluidStack != null && fluidStack.amount > this.getCapacity()) {
            fluidStack.amount = this.getCapacity();
        }
        this.tanks.setFluid(fluidStack);
    }

    public boolean restrictNBTCopy() {
        return true;
    }

    public ItemStack createDropStack(XUBlockState blockState) {
        int meta = blockState.dropMeta;
        ItemStack itemStack = new ItemStack(blockState.func_177230_c(), 1, meta);
        NBTTagCompound nbt = this.tanks.serializeNBT();
        itemStack.func_77983_a("Fluid", (NBTBase)nbt);
        return itemStack;
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        FluidStack fluid = this.tanks.getFluid();
        if (fluid != null) {
            fluid = fluid.copy();
            fluid.amount = 1;
        }
        packet.writeFluidStack(fluid);
    }

    @Override
    @Nullable
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.tanks;
    }

    @Override
    public boolean hasComparatorLevels() {
        return true;
    }

    @Override
    public int getComparatorLevel() {
        int amount = this.tanks.getFluidAmount();
        if (amount == 0) {
            return 0;
        }
        return 1 + amount * 14 / this.tanks.getCapacity();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.delayTicks = Math.max(0, this.delayTicks - 1);
        if (this.delayTicks == 0) {
            TileEntity up;
            try {
                this.hasFluid = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c, null).drain((int)1, (boolean)false).amount == 1;
            }
            catch (NullPointerException e) {
                this.hasFluid = false;
            }
            if (this.tanks.getFluidAmount() == 0 || !this.hasFluid) {
                if (!this.empty) {
                    this.empty = true;
                    this.markForUpdate();
                    this.func_70296_d();
                }
            } else {
                if (this.empty) {
                    this.markForUpdate();
                    this.func_70296_d();
                }
                this.empty = false;
                if (this instanceof TankInf && this.tanks.getFluidAmount() != this.tanks.getCapacity()) {
                    this.tanks.setFluid(new FluidStack(this.tanks.getFluid(), this.tanks.getCapacity()));
                }
            }
            if ((up = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1, 0))) instanceof TileDrum && ((TileDrum)up).tanks.getFluidAmount() > 0) {
                IFluidHandler upDrum = ((TileDrum)up).getFluidHandler(EnumFacing.DOWN);
                if (this.tanks.getFluidAmount() <= 0 || ((TileDrum)up).tanks.getFluid().isFluidEqual(this.tanks.getFluid())) {
                    int drainAmount = Math.min(Math.min((int)((double)((TileDrum)up).getCapacity() * 0.1), ((TileDrum)up).tanks.getFluidAmount()), this.tanks.getCapacity() - this.tanks.getFluidAmount());
                    FluidStack insertFluid = new FluidStack(((TileDrum)up).tanks.getFluid().getFluid(), drainAmount);
                    if (((TileDrum)up).tanks.getFluidAmount() == drainAmount) {
                        ((TileDrum)up).markForUpdate();
                        up.func_70296_d();
                    }
                    upDrum.drain(drainAmount, true);
                    this.getFluidHandler(EnumFacing.UP).fill(insertFluid, true);
                }
            }
            this.delayTicks = 20;
        }
        --this.delayTicks;
    }

    public static class TankInf
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 1000001000;
        }

        @Override
        public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
            IFluidHandlerItem container;
            if (worldIn.field_72995_K) {
                return true;
            }
            if (StackHelper.isNull(heldItem) || (container = FluidUtil.getFluidHandler((ItemStack)heldItem)) == null) {
                return true;
            }
            if (this.tanks.getFluidAmount() == 0) {
                if (playerIn.field_71075_bZ.field_75098_d) {
                    FluidStack fluid = container.drain(Integer.MAX_VALUE, false);
                    if (fluid == null) {
                        return true;
                    }
                    this.tanks.setFluid(fluid.copy());
                    this.markForUpdate();
                    this.func_70296_d();
                }
                return true;
            }
            if (this.attemptFill(playerIn, hand, heldItem, (IFluidHandler)container)) {
                return true;
            }
            return true;
        }

        @Override
        @Nullable
        public IFluidHandler getFluidHandler(EnumFacing facing) {
            return new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return tanks.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (resource == null) {
                        return null;
                    }
                    return this.drain(resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    FluidStack fluid = tanks.getFluid();
                    if (fluid == null) {
                        return null;
                    }
                    FluidStack copy = fluid.copy();
                    copy.amount = maxDrain;
                    return copy;
                }
            };
        }
    }

    public static class Tank1000000
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 1000000000;
        }
    }

    public static class Tank10000
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 10000000;
        }
    }

    public static class Tank1000
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 1000000;
        }
    }

    public static class Tank100
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 100000;
        }
    }

    public static class Tank10
    extends TileDrum {
        @Override
        protected int getCapacity() {
            return 10000;
        }
    }
}

