/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerUpgrades;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.RedstoneState;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileAdvInteractor
extends TilePower
implements ITickable,
IDynamicHandler {
    public static final EnumSet<Upgrade> SPEED = EnumSet.of(Upgrade.SPEED);
    public NBTSerializable.NBTEnum<RedstoneState> redstone_state = this.registerNBT("redstone", new NBTSerializable.NBTEnum<RedstoneState>(RedstoneState.OPERATE_ALWAYS));
    public NBTSerializable.Int pulses = this.registerNBT("pulses", new NBTSerializable.Int());
    public NBTSerializable.Int cooldown = this.registerNBT("cooldown", new NBTSerializable.Int());
    public SingleStackHandlerUpgrades upgrades = this.registerNBT("upgrades", new SingleStackHandlerUpgrades(SPEED){

        @Override
        protected void onContentsChanged() {
            TileAdvInteractor.this.func_70296_d();
            PowerManager.instance.markDirty(TileAdvInteractor.this);
        }
    });
    public NBTSerializable.NBTBoolean powered = this.registerNBT("powered", new NBTSerializable.NBTBoolean());

    public static WidgetClickMCButtonChoices<RedstoneState> getRSWidget(int x, int y, final @Nonnull NBTSerializable.NBTEnum<RedstoneState> redstone_state, final @Nullable NBTSerializable.Int pulses) {
        WidgetClickMCButtonChoices<RedstoneState> button = new WidgetClickMCButtonChoices<RedstoneState>(x, y){

            @Override
            protected void onSelectedServer(RedstoneState marker) {
                redstone_state.value = marker;
                if (pulses != null) {
                    pulses.value = 0;
                }
            }

            @Override
            public RedstoneState getSelectedValue() {
                return (RedstoneState)((Object)redstone_state.value);
            }
        };
        ((WidgetClickMCButtonChoices)((WidgetClickMCButtonChoices)button.addChoice(RedstoneState.OPERATE_ALWAYS, new ItemStack(Items.field_151016_H), Lang.translate("Always On"))).addChoice((RedstoneState)RedstoneState.OPERATE_REDSTONE_ON, new ItemStack(Items.field_151137_ax), Lang.translate("Redstone On"))).addChoice((RedstoneState)RedstoneState.OPERATE_REDSTONE_OFF, new ItemStack(Blocks.field_150429_aA), Lang.translate("Redstone Off"));
        if (pulses != null) {
            button.addChoice(RedstoneState.OPERATE_REDSTONE_PULSE, new ItemStack(Items.field_151107_aW), Lang.translate("Redstone Pulse"));
        }
        return button;
    }

    @Override
    protected abstract Iterable<ItemStack> getDropHandler();

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.active) {
            return;
        }
        if (!this.preOperate()) {
            return;
        }
        if (this.cooldown.value > 0) {
            this.cooldown.value -= 1 + this.upgrades.getLevel(Upgrade.SPEED);
            if (this.cooldown.value > 0) {
                return;
            }
        }
        switch ((RedstoneState)((Object)this.redstone_state.value)) {
            case OPERATE_REDSTONE_ON: {
                if (this.powered.value) break;
                return;
            }
            case OPERATE_REDSTONE_OFF: {
                if (!this.powered.value) break;
                return;
            }
            case OPERATE_REDSTONE_PULSE: {
                if (this.pulses.value == 0) {
                    return;
                }
                --this.pulses.value;
            }
        }
        while (this.cooldown.value <= 0) {
            this.cooldown.value += 20;
            if (this.operate()) continue;
            break;
        }
    }

    public boolean preOperate() {
        return true;
    }

    protected abstract boolean operate();

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        boolean newPower;
        boolean wasPowered = this.powered.value;
        boolean bl = newPower = worldIn.func_175687_A(pos) > 0;
        if (newPower != wasPowered) {
            this.powered.value = newPower;
            if (newPower && this.redstone_state.value == RedstoneState.OPERATE_REDSTONE_PULSE) {
                ++this.pulses.value;
            }
        }
    }

    @Override
    public float getPower() {
        int level = this.upgrades.getLevel(Upgrade.SPEED);
        if (level == 0) {
            return Float.NaN;
        }
        return Upgrade.SPEED.getPowerUse(level);
    }

    @Override
    public void onPowerChanged() {
    }
}

