/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.fluids;

import com.rwtema.extrautils2.fluids.IOptionalFluid;
import com.rwtema.extrautils2.utils.helpers.NBTCopyHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.Validate;

public class OptionalFluidSpecification
implements IOptionalFluid {
    private static HashMap<String, OptionalFluidSpecification> cache = new HashMap();
    @Nullable
    Fluid fluid;

    @SubscribeEvent
    public static void registerFluid(FluidRegistry.FluidRegisterEvent event) {
        for (Map.Entry entry2 : FluidRegistry.getRegisteredFluids().entrySet()) {
            OptionalFluidSpecification specification = cache.get(entry2.getKey());
            if (specification == null) continue;
            specification.fluid = (Fluid)entry2.getValue();
        }
    }

    public static IOptionalFluid getInstance(Fluid fluid) {
        return OptionalFluidSpecification.doCreate(fluid.getName());
    }

    public static IOptionalFluid getInstance(String fluid) {
        return OptionalFluidSpecification.doCreate(fluid);
    }

    private static IOptionalFluid doCreate(String name) {
        return cache.computeIfAbsent(name, s -> {
            OptionalFluidSpecification specification = new OptionalFluidSpecification();
            specification.fluid = FluidRegistry.getFluid((String)s);
            return specification;
        });
    }

    public static IOptionalFluid create(FluidStack stack) {
        if (stack.tag == null) {
            return OptionalFluidSpecification.getInstance(stack.getFluid());
        }
        return new NBTVariant(OptionalFluidSpecification.getInstance(stack.getFluid()), stack.tag);
    }

    @Override
    public boolean isPresent() {
        return this.fluid != null;
    }

    @Override
    public FluidStack createStack(int amount) {
        return new FluidStack((Fluid)Validate.notNull((Object)this.fluid), amount);
    }

    @Override
    public boolean matches(FluidStack stack) {
        return stack != null && this.fluid != null && this.fluid == stack.getFluid();
    }

    static {
        MinecraftForge.EVENT_BUS.register(OptionalFluidSpecification.class);
    }

    public static class NBTVariant
    extends OptionalFluidSpecification {
        final IOptionalFluid parent;
        final NBTTagCompound tag;

        public NBTVariant(IOptionalFluid parent, NBTTagCompound tag) {
            this.parent = parent;
            this.tag = NBTCopyHelper.copyAndHashNBT((NBTTagCompound)tag).copy;
        }

        @Override
        public boolean isPresent() {
            return this.parent.isPresent();
        }

        @Override
        public boolean matches(FluidStack stack) {
            return this.parent.matches(stack) && NBTCopyHelper.equalNBT(this.tag, stack.tag);
        }

        @Override
        public FluidStack createStack(int amount) {
            FluidStack stack = this.parent.createStack(amount);
            stack.tag = NBTCopyHelper.copyAndHashNBT((NBTTagCompound)this.tag).copy;
            return stack;
        }
    }
}

