/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.BoxSingleQuad;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.particles.PacketParticleSplosion;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockSpike
extends XUBlockStatic {
    public static final DamageSource spike_creative = new DamageSource("spike_creative").func_76348_h();
    static final float bounds = 0.03125f;
    private static final String spikeDamageName = "spike";
    public static final DamageSource spike = new DamageSource("spike");
    final SpikeType type;

    public BlockSpike(SpikeType type) {
        super(type.material);
        this.type = type;
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addWorldProperties(new IProperty[]{XUBlockStateCreator.ROTATION_ALL}).build();
    }

    public void onBlockExploded(World world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
        if (this.field_149782_v >= 0.0f) {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        float base_height = 0.0625f;
        BoxModel model = new BoxModel();
        model.renderAsNormalBlock = false;
        model.overrideBounds = new Box(0.03125f, 0.03125f, 0.03125f, 0.96875f, 0.96875f, 0.96875f);
        model.addBox(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f).setTexture("spikes/spike_" + this.type.name() + "_base");
        for (int i = 0; i < 4; ++i) {
            model.add(new BoxSingleQuad(new UV(1.0f, 0.0625f, 0.0f, 0.0f, 0.0625f), new UV(0.0f, 0.0625f, 0.0f, 1.0f, 0.0625f), new UV(0.5f, 1.0f, 0.5f, 0.5f, 1.0f), new UV(0.5f, 1.0f, 0.5f, 0.5f, 1.0f)).setDoubleSided(false).setTexture("spikes/spike_" + this.type.name() + "_side").rotateY(i));
        }
        model = model.rotateToSide((EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL));
        return model;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxBase(IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos) {
        return new AxisAlignedBB(0.03125, 0.03125, 0.03125, 0.96875, 0.96875, 0.96875);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.field_149782_v >= 0.0f && super.canEntityDestroy(state, world, pos, entity);
    }

    @Override
    public void addCollisionBoxToListBase(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        AxisAlignedBB collisionBoundingBox;
        if (this.isIgnored(entityIn)) {
            collisionBoundingBox = Block.field_185505_j;
        } else {
            switch ((EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL)) {
                case DOWN: {
                    collisionBoundingBox = new AxisAlignedBB(0.03125, 0.0, 0.03125, 0.96875, 0.96875, 0.96875);
                    break;
                }
                case UP: {
                    collisionBoundingBox = new AxisAlignedBB(0.03125, 0.03125, 0.03125, 0.96875, 1.0, 0.96875);
                    break;
                }
                case NORTH: {
                    collisionBoundingBox = new AxisAlignedBB(0.03125, 0.03125, 0.0, 0.96875, 0.96875, 0.96875);
                    break;
                }
                case SOUTH: {
                    collisionBoundingBox = new AxisAlignedBB(0.03125, 0.03125, 0.03125, 0.96875, 0.96875, 1.0);
                    break;
                }
                case WEST: {
                    collisionBoundingBox = new AxisAlignedBB(0.0, 0.03125, 0.03125, 0.96875, 0.96875, 0.96875);
                    break;
                }
                case EAST: {
                    collisionBoundingBox = new AxisAlignedBB(0.03125, 0.03125, 0.03125, 1.0, 0.96875, 0.96875);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid side");
                }
            }
        }
        BlockSpike.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)collisionBoundingBox);
    }

    private boolean isIgnored(Entity entityIn) {
        return this.type.isIgnored(entityIn);
    }

    @Override
    @Nonnull
    public IBlockState xuOnBlockPlacedBase(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.xuBlockState.getStateFromDropMeta(meta).func_177226_a((IProperty)XUBlockStateCreator.ROTATION_ALL, (Comparable)facing.func_176734_d());
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (this.isIgnored(entityIn)) {
            return;
        }
        if (entityIn instanceof EntityLivingBase) {
            this.type.hurtEntity(worldIn, pos, state, (EntityLivingBase)entityIn);
        }
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.type.addInformation(stack, playerIn, tooltip, advanced);
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, EnumFacing axis) {
        if (this.field_149782_v < 0.0f) {
            return false;
        }
        return super.rotateBlock(world, pos, axis);
    }

    @Override
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        if (this.field_149782_v < 0.0f) {
            return state;
        }
        return super.func_185499_a(state, rot);
    }

    @Nonnull
    public EnumFacing[] getValidRotations(World world, @Nonnull BlockPos pos) {
        if (this.field_149782_v < 0.0f) {
            return null;
        }
        return super.getValidRotations(world, pos);
    }

    static {
        Lang.translate("death.attack.spike", "%1$s walked on a pointy spike (ouchies)");
        Lang.translate("death.attack.spike.item", "%1$s walked on a pointy spike (ouchies)");
        Lang.translate("death.attack.spike_creative", "%1$s failed to become the guy");
        Lang.translate("death.attack.spike_creative.item", "%1$s failed to become the guy");
    }

    public static final class EventHandler {
        static final WeakLinkedSet<EntityLivingBase> entitiesToKillDrops = new WeakLinkedSet();

        @SubscribeEvent
        public static void killDrops(LivingDropsEvent event) {
            EntityLivingBase base = event.getEntityLiving();
            if (entitiesToKillDrops.contains(base)) {
                event.setCanceled(true);
            }
        }
    }

    public static class Creative
    extends BlockSpike {
        public Creative() {
            super(SpikeType.creative);
            if (!ExtraUtils2.allowNonCreativeHarvest) {
                this.func_149722_s();
            }
            this.func_149752_b(6000000.0f);
        }

        @Override
        public void neighborChangedBase(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
            if (pos.func_177956_o() != 1) {
                return;
            }
            if (state.func_177230_c() != this) {
                return;
            }
            EnumFacing value = (EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
            if (value != EnumFacing.DOWN) {
                return;
            }
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150357_h) {
                BlockPos up = pos.func_177984_a();
                IBlockState blockState = worldIn.func_180495_p(up);
                Block block = blockState.func_177230_c();
                if (block.isAir(state, (IBlockAccess)worldIn, up)) {
                    return;
                }
                if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
                    worldIn.func_180501_a(up, Blocks.field_150350_a.func_176223_P(), 2);
                } else {
                    worldIn.func_175655_b(up, true);
                }
            }
        }
    }

    public static enum SpikeType {
        wood(Material.field_151575_d, 1.0f, Items.field_151041_m, new ItemStack(Blocks.field_150344_f), new ItemStack(Blocks.field_150364_r)){

            @Override
            public void hurtEntity(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase entityIn) {
                if (entityIn.func_110143_aJ() <= this.amount) {
                    return;
                }
                super.hurtEntity(worldIn, pos, state, entityIn);
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Reduces health to half a heart, but doesn't kill"));
            }
        }
        ,
        stone(Material.field_151576_e, 2.0f, Items.field_151052_q, "cobblestone", "compressed1xCobblestone"),
        iron(Material.field_151573_f, 4.0f, Items.field_151040_l, "ingotIron", "blockIron"),
        gold(Material.field_151573_f, 2.0f, Items.field_151010_B, "ingotGold", "blockGold"){

            @Override
            public void hurtEntity(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase entityIn) {
                entityIn.func_70097_a(spike, this.amount);
                entityIn.field_70718_bc = 100;
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Mobs drop experience"));
            }
        }
        ,
        diamond(Material.field_151573_f, 8.0f, Items.field_151048_u, "gemDiamond", "blockDiamond"){

            @Override
            public void hurtEntity(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase entityIn) {
                float min = Math.min(this.amount, entityIn.func_110143_aJ() - 1.0E-4f);
                entityIn.func_70097_a(spike, min);
                if (entityIn.func_110143_aJ() <= 0.001f) {
                    if (worldIn instanceof WorldServer) {
                        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)worldIn));
                        entityIn.func_70097_a((DamageSource)new EntityDamageSource(BlockSpike.spikeDamageName, (Entity)fakePlayer), this.amount * 1000.0f);
                    } else {
                        super.hurtEntity(worldIn, pos, state, entityIn);
                    }
                }
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Mobs drop 'Player-kill only' items"));
            }
        }
        ,
        creative(Material.field_151576_e, 8000.0f, null, null, null){
            {
                MinecraftForge.EVENT_BUS.register(EventHandler.class);
            }

            @Override
            public void hurtEntity(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase entityIn) {
                EventHandler.entitiesToKillDrops.add(entityIn);
                for (int i = 0; i < 100 && entityIn.func_70097_a(spike_creative, this.amount); ++i) {
                }
                EventHandler.entitiesToKillDrops.remove(entityIn);
                if (entityIn.func_110143_aJ() <= 0.0f && entityIn instanceof EntityLiving) {
                    EntityLiving entityLiving = (EntityLiving)entityIn;
                    NetworkHandler.sendToAllAround(new PacketParticleSplosion(entityIn.func_145782_y()), entityLiving.field_70170_p.field_73011_w.getDimension(), entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 64.0);
                    entityLiving.field_70728_aV = 0;
                }
            }

            @Override
            public boolean isIgnored(Entity entityIn) {
                return false;
            }
        };

        public final Material material;
        public final float amount;
        public final Item sword;
        public final Object itemIngot;
        public final Object itemBlock;

        private SpikeType(Material material, float amount, Item sword, Object itemIngot, Object itemBlock) {
            this.material = material;
            this.amount = amount;
            this.sword = sword;
            this.itemIngot = itemIngot;
            this.itemBlock = itemBlock;
        }

        public static void addRecipes(BlockEntry<BlockSpike> entry2) {
            SpikeType type = ((BlockSpike)entry2.value).type;
            CraftingHelper.addShaped("spike_" + type.name().toLowerCase(Locale.ENGLISH), entry2.newStack(4), " S ", "SIS", "IBI", Character.valueOf('S'), type.sword, Character.valueOf('I'), type.itemIngot, Character.valueOf('B'), type.itemBlock);
        }

        public void hurtEntity(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase entityIn) {
            entityIn.func_70097_a(spike, this.amount);
            if (entityIn.func_110143_aJ() <= 0.0f && entityIn instanceof EntityLiving) {
                ((EntityLiving)entityIn).field_70728_aV = 0;
            }
        }

        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        }

        public boolean isIgnored(Entity entityIn) {
            return entityIn instanceof EntityItem || entityIn instanceof EntityXPOrb;
        }
    }
}

