/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockConnectedTextureBase;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.textures.ConnectedTexture;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDecorativeGlass
extends XUBlockConnectedTextureBase {
    public static final PropertyEnumSimple<DecorStates> decor = new PropertyEnumSimple<DecorStates>(DecorStates.class);

    public BlockDecorativeGlass() {
        super(Material.field_151592_s);
    }

    public boolean func_149751_l(IBlockState state) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).opacity == 0;
    }

    public float func_185485_f(IBlockState state) {
        return this.func_149751_l(state) ? 1.0f : 0.2f;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        for (DecorStates decorState : DecorStates.values()) {
            decorState.tex = new ConnectedTexture(decorState.toString(), this.xuBlockState.defaultState.func_177226_a((IProperty)decor, (Comparable)((Object)decorState)), this);
        }
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, false, new IProperty[]{decor});
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISolidWorldTexture getConnectedTexture(IBlockState state, EnumFacing side) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).tex;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).opacity;
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).light_level;
    }

    @Override
    public BlockRenderLayer renderLayer(IBlockState state) {
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).layer;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state.func_177230_c() == this && ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).redstone_level > 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        if (state == null) {
            if (worldIn instanceof World && !((World)worldIn).func_175667_e(pos)) {
                return 0;
            }
            state = worldIn.func_180495_p(pos);
        }
        if (state.func_177230_c() != this) {
            return 0;
        }
        return ((DecorStates)((Object)state.func_177229_b(BlockDecorativeGlass.decor))).redstone_level;
    }

    public static enum DecorStates implements IItemStackMaker
    {
        glass{
            {
                this.layer = BlockRenderLayer.TRANSLUCENT;
                this.light_level = 15;
            }

            @Override
            public void addRecipes() {
            }
        }
        ,
        darkglass{
            {
                this.layer = BlockRenderLayer.TRANSLUCENT;
                this.opacity = 255;
            }

            @Override
            public void addRecipes() {
            }
        };

        @SideOnly(value=Side.CLIENT)
        public ISolidWorldTexture tex;
        int opacity = 0;
        int light_level = 0;
        int redstone_level = 0;
        BlockRenderLayer layer = BlockRenderLayer.CUTOUT;

        public abstract void addRecipes();

        @Override
        public ItemStack newStack(int amount) {
            return XU2Entries.decorativeGlass.newStack(amount, new Object[]{decor, this});
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }
    }
}

