/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.base.Throwables;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.utils.PositionPool;
import com.rwtema.extrautils2.utils.blockaccess.BlockAccessEmpty;
import com.rwtema.extrautils2.utils.blockaccess.BlockAccessMimic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BoxMimic
extends Box {
    public static ThreadLocal<BlockAccessMimic> blockAccessMimicThreadLocal = ThreadLocal.withInitial(() -> new BlockAccessMimic());
    IBlockAccess world;
    BlockPos pos;
    IBlockState mimicState;

    public BoxMimic(IBlockState mimicState) {
        this(BlockAccessEmpty.INSTANCE, PositionPool.MID_HEIGHT, mimicState);
    }

    public BoxMimic(IBlockAccess world, BlockPos pos, IBlockState mimicState) {
        super(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.world = world;
        this.pos = pos;
        this.mimicState = mimicState;
        ExtraUtils2.proxy.run(new ClientRunnable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                BoxMimic.this.layer = BoxMimic.this.mimicState.func_177230_c().func_180664_k();
            }
        });
    }

    @Override
    public Box copy() {
        return new BoxMimic(this.world, this.pos, this.mimicState);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> makeQuads(@Nullable EnumFacing side) {
        BlockAccessMimic blockAccessMimic = blockAccessMimicThreadLocal.get();
        try {
            blockAccessMimic.setBase(this.world);
            blockAccessMimic.state = this.mimicState;
            blockAccessMimic.myPos = this.pos;
            IBakedModel modelFromBlockState = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.mimicState);
            IBlockState extendedState = this.mimicState.func_177230_c().getExtendedState(this.mimicState, (IBlockAccess)blockAccessMimic, this.pos);
            List array = modelFromBlockState.func_188616_a(extendedState, side, 0L);
            blockAccessMimic.setBase(null);
            return array;
        }
        catch (Throwable throwable) {
            blockAccessMimic.setBase(null);
            throw Throwables.propagate((Throwable)throwable);
        }
    }
}

