/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.IMetaProperty;
import com.rwtema.extrautils2.backend.IRegisterItemColors;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.PassthruModelBlock;
import com.rwtema.extrautils2.backend.model.PassthruModelItemBlock;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.compatibility.BlockCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.quarry.TileQuarry;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.blockaccess.BlockAccessSingle;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class XUBlock
extends BlockCompat
implements IRegisterItemColors {
    public static final List<XUBlock> blocks = Lists.newArrayList();
    public XUBlockStateCreator xuBlockState;
    public XUItemBlock itemBlock;
    protected ThreadLocal<XUTile> droppingTileEntity = new ThreadLocal();
    private boolean hasTile;
    private boolean finishedCreating = true;

    public XUBlock() {
        this(Material.field_151576_e);
    }

    public XUBlock(Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    public XUBlock(Material materialIn, MapColor color) {
        super(materialIn, color);
        this.func_149647_a(ExtraUtils2.creativeTabExtraUtils);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setBlockState((XUBlockStateCreator)this.field_176227_L);
        ExtraUtils2.proxy.registerBlock(this);
        blocks.add(this);
    }

    public static <T extends Comparable<T>> T getPropertySafe(World world, BlockPos pos, IProperty<T> property, T _default) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177228_b().containsKey(property)) {
            return (T)blockState.func_177229_b(property);
        }
        return _default;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return super.isSideSolid(base_state, world, pos, side);
    }

    @Override
    public boolean causesDownwardCurrent(IBlockAccess worldIn, @Nonnull BlockPos pos, EnumFacing side) {
        return this.getWorldModel(worldIn, pos, null).isFullCube();
    }

    public boolean func_149662_c(IBlockState state) {
        return this.finishedCreating && this.getGenericWorldModel(state).isFullCube();
    }

    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator(this);
    }

    public void setBlockName(String s) {
        this.func_149663_c(s);
    }

    @Nonnull
    public abstract BoxModel getWorldModel(IBlockAccess var1, BlockPos var2, @Nullable IBlockState var3);

    public BoxModel getGenericWorldModel(IBlockState state) {
        BlockAccessSingle blockAccessSingle = (BlockAccessSingle)BlockAccessSingle.cache.getUnchecked((Object)state);
        return this.getWorldModel(blockAccessSingle, BlockAccessSingle.CENTER, state);
    }

    @SideOnly(value=Side.CLIENT)
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return this.getWorldModel(world, pos, state);
    }

    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        return super.canRenderInLayer(state, layer);
    }

    public boolean func_149637_q(IBlockState state) {
        return this.getGenericWorldModel(state).isFullCube();
    }

    public boolean func_149721_r(IBlockState state) {
        return this.getGenericWorldModel(state).isFullCube();
    }

    public boolean func_149686_d(IBlockState state) {
        return this.getGenericWorldModel(state).isFullCube();
    }

    public boolean func_149730_j(IBlockState state) {
        return this.getGenericWorldModel(state).isFullCube();
    }

    @Override
    public void getSubBlocksBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (this.xuBlockState.mainBlock == this) {
            for (int i = 0; i < this.xuBlockState.dropmeta2state.length; ++i) {
                list.add(new ItemStack(itemIn, 1, i));
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return false;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof XUTile) {
            return ((XUTile)te).getComparatorLevel();
        }
        return 0;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public abstract BoxModel getInventoryModel(@Nullable ItemStack var1);

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        BoxModel worldModel = this.getRenderModel(world, pos, state);
        ((XUBlockState)state).load(worldModel);
        return state;
    }

    @Nonnull
    public BlockStateContainer func_176194_O() {
        return this.xuBlockState;
    }

    public void setBlockState(XUBlockStateCreator creator) {
        this.xuBlockState = creator;
        boolean hasTile = false;
        for (IBlockState iBlockState : this.xuBlockState.func_177619_a()) {
            if (!this.hasTileEntity(iBlockState)) continue;
            hasTile = true;
            break;
        }
        this.hasTile = hasTile;
        if (this.itemBlock != null) {
            this.itemBlock.func_77627_a(this.xuBlockState.dropmeta2state.length > 1);
        }
        this.func_180632_j((IBlockState)creator.defaultState);
    }

    @Override
    public void addCollisionBoxToListBase(IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        BoxModel models = this.getWorldModel((IBlockAccess)worldIn, pos, state);
        if (models.isEmpty()) {
            return;
        }
        for (Box b : models) {
            AxisAlignedBB aabb;
            if (b.noCollide || !entityBox.func_72326_a(aabb = new AxisAlignedBB((double)((float)pos.func_177958_n() + b.minX), (double)((float)pos.func_177956_o() + b.minY), (double)((float)pos.func_177952_p() + b.minZ), (double)((float)pos.func_177958_n() + b.maxX), (double)((float)pos.func_177956_o() + b.maxY), (double)((float)pos.func_177952_p() + b.maxZ)))) continue;
            collidingBoxes.add(aabb);
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB aabb = this.getWorldModel(source, pos, state).getAABB(false);
        return aabb != null ? aabb : field_185505_j;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        BoxModel worldModel = this.getWorldModel((IBlockAccess)worldIn, pos, blockState);
        if (worldModel.overrideBounds != null) {
            return super.func_180636_a(blockState, worldIn, pos, start, end);
        }
        RayTraceResult result = null;
        for (Box box : worldModel) {
            RayTraceResult r = this.func_185503_a(pos, start, end, box.toAABB());
            if (r == null || result != null && !(start.func_72438_d(r.field_72307_f) < start.func_72438_d(result.field_72307_f))) continue;
            result = r;
            result.subHit = box.tint;
        }
        return result;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.xuOnBlockPlacedBase(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    @Nonnull
    public IBlockState xuOnBlockPlacedBase(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.xuBlockState.getStateFromDropMeta(meta);
    }

    public int func_180651_a(IBlockState state) {
        return this.xuBlockState.getDropMetaFromState(state);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.xuBlockState.getStateFromMeta(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.xuBlockState.getMetaFromState(state);
    }

    protected ItemStack func_180643_i(@Nonnull IBlockState state) {
        Item item = Item.func_150898_a((Block)this.xuBlockState.mainBlock);
        if (item == StackHelper.nullItem()) {
            return StackHelper.empty();
        }
        if (item.func_77614_k()) {
            return new ItemStack(item, 1, this.xuBlockState.getDropMetaFromState(state));
        }
        return new ItemStack(item);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.xuBlockState.mainBlock);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
    }

    public void postTextureRegister() {
    }

    public XUTile getTile(IBlockAccess world, BlockPos pos) {
        if (this.hasTile) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof XUTile) {
                return (XUTile)tile;
            }
            if (tile != null && world.func_180495_p(pos).func_177230_c() == this) {
                tile.func_145843_s();
            }
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        XUTile checkTile;
        if (this.hasTile && (checkTile = this.getTile((IBlockAccess)worldIn, pos)) != null) {
            checkTile.onBlockPlacedBy(worldIn, pos, state, placer, stack, this);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        Optional<ItemStack> stack;
        TileEntity te;
        if (this.hasTile && (te = world.func_175625_s(pos)) != null && !(te instanceof TileQuarry) && (stack = ((XUTile)te).getPickBlock(player, target)) != null) {
            return stack.orElse(StackHelper.empty());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180657_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        if (this.hasTile && te instanceof XUTile) {
            XUTile xuTile = (XUTile)te;
            if (xuTile.harvestBlock(worldIn, player, pos, this, state)) {
                return;
            }
            this.droppingTileEntity.set(xuTile);
            super.func_180657_a(worldIn, player, pos, state, te, stack);
            this.droppingTileEntity.set(null);
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    @Override
    @Nonnull
    public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (this.hasTile && this.hasTileEntity(state)) {
            Item item;
            NBTTagCompound saveInfo;
            TileEntity te;
            XUTile xuTile = this.droppingTileEntity.get();
            if (xuTile == null && (te = world.func_175625_s(pos)) instanceof XUTile) {
                xuTile = (XUTile)te;
            }
            if (xuTile != null && (saveInfo = xuTile.getSaveInfo()) != null && (item = Item.func_150898_a((Block)this.xuBlockState.mainBlock)) != null) {
                ItemStack stack = new ItemStack(item, 1, this.func_180651_a(state));
                stack.func_77982_d(saveInfo);
                return Lists.newArrayList((Object[])new ItemStack[]{stack});
            }
        }
        return super.getDrops(world, pos, state, fortune);
    }

    @Override
    public void neighborChangedBase(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        XUTile checkTile;
        if (this.hasTile && this.hasTileEntity(state) && (checkTile = this.getTile((IBlockAccess)worldIn, pos)) != null) {
            checkTile.onNeighborBlockChange(worldIn, pos, state, neighborBlock);
        }
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        XUTile checkTile;
        if (this.hasTile && (checkTile = this.getTile((IBlockAccess)worldIn, pos)) != null) {
            checkTile.breakBlock(worldIn, pos, state);
        }
    }

    public void clearCaches() {
    }

    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInventoryQuads(MutableModel result, ItemStack stack) {
        BoxModel inventoryModel = this.getInventoryModel(stack);
        inventoryModel.loadIntoMutable(result, null);
    }

    @SideOnly(value=Side.CLIENT)
    public MutableModel createInventoryMutableModel() {
        return new MutableModel(Transforms.blockTransforms);
    }

    @Nonnull
    public AxisAlignedBB func_180640_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return this.getWorldModel((IBlockAccess)world, pos, state).getAABB(pos, false);
    }

    public <T extends Comparable<T>> T getMyPropertySafe(World world, BlockPos pos, IProperty<T> property) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            return (T)state.func_177229_b(property);
        }
        return (T)this.func_176223_P().func_177229_b(property);
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState newState = state;
        for (IMetaProperty<? extends Comparable> hiddenProperty : this.xuBlockState.hiddenProperties) {
            newState = newState.func_177226_a(hiddenProperty, hiddenProperty.calculateValue(worldIn, pos, state));
        }
        return newState;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("facing") && !prop.func_177701_a().equals("rotation")) continue;
            IProperty propFacing = prop;
            EnumFacing value = (EnumFacing)state.func_177229_b(propFacing);
            EnumFacing facing = rot.func_185831_a(value);
            return state.func_177226_a(propFacing, (Comparable)facing);
        }
        return state;
    }

    @Override
    public boolean onBlockActivatedBase(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        XUTile checkTile;
        return this.hasTile && this.hasTileEntity(state) && (checkTile = this.getTile((IBlockAccess)worldIn, pos)) != null && checkTile.onBlockActivated(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return super.func_176205_b(worldIn, pos) || this.getWorldModel(worldIn, pos, null).getPassable();
    }

    public void onCreated(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        AchievementHelper.checkForPotentialAwards(playerIn, stack);
    }

    public boolean getHasSubtypes() {
        return this.xuBlockState.dropmeta2state.length > 1;
    }

    @SideOnly(value=Side.CLIENT)
    public PassthruModelBlock createPassthruModel(IBlockState state, ModelResourceLocation location) {
        return new PassthruModelBlock(this, state, location);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return null;
    }

    public EnumRarity getRarity(ItemStack stack) {
        return null;
    }

    public EnumActionResult hasEffect(ItemStack stack) {
        return EnumActionResult.PASS;
    }

    public XUBlockState getStateFromItemStack(@Nullable ItemStack item) {
        if (StackHelper.isNull(item)) {
            return this.xuBlockState.defaultState;
        }
        return this.xuBlockState.getStateFromDropMeta(item.func_77952_i());
    }

    public boolean canReplaceBase(World p_176193_1_, BlockPos p_176193_2_, EnumFacing p_176193_3_, ItemStack p_176193_4_) {
        return this.func_176198_a(p_176193_1_, p_176193_2_, p_176193_3_);
    }

    public String getSuffix(ItemStack stack) {
        return this.xuBlockState.getStateFromItemStack((ItemStack)stack).dropName;
    }

    public boolean allowOverride() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel createItemBlockPassThruModel(XUItemBlock item) {
        return new PassthruModelItemBlock(item);
    }

    @Nonnull
    public String getOverrideStackDisplayName(ItemStack stack, String name) {
        return name;
    }

    @SideOnly(value=Side.CLIENT)
    public MutableModel recreateNewInstance(MutableModel result) {
        return this.createInventoryMutableModel();
    }
}

