/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketClientToServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public interface ILeftClickHandler {
    public boolean leftClick(World var1, EntityPlayer var2, ItemStack var3);

    @NetworkHandler.XUPacket
    public static class PacketSendLeftClick
    extends XUPacketClientToServer {
        private ItemStack stack = StackHelper.empty();
        private EntityPlayer player;

        public PacketSendLeftClick() {
        }

        public PacketSendLeftClick(ItemStack stack) {
            this.stack = stack;
        }

        @SubscribeEvent
        public static void handleLeftBlock(PlayerInteractEvent.LeftClickBlock event) {
            ILeftClickHandler leftClickHandler;
            ItemStack stack = event.getItemStack();
            if (StackHelper.isNonNull(stack) && stack.func_77973_b() instanceof ILeftClickHandler && (leftClickHandler = (ILeftClickHandler)stack.func_77973_b()).leftClick(event.getWorld(), event.getEntityPlayer(), event.getItemStack())) {
                event.setCanceled(true);
                if (event.getWorld().field_72995_K) {
                    NetworkHandler.sendPacketToServer(new PacketSendLeftClick(stack));
                }
            }
        }

        @SubscribeEvent
        public static void handleLeftEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            ILeftClickHandler leftClickHandler;
            ItemStack stack = event.getItemStack();
            if (StackHelper.isNonNull(stack) && stack.func_77973_b() instanceof ILeftClickHandler && (leftClickHandler = (ILeftClickHandler)stack.func_77973_b()).leftClick(event.getWorld(), event.getEntityPlayer(), event.getItemStack()) && event.getWorld().field_72995_K) {
                NetworkHandler.sendPacketToServer(new PacketSendLeftClick(stack));
            }
        }

        @Override
        public void writeData() throws Exception {
            this.writeItemStack(this.stack);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.player = player;
            this.stack = this.readItemStack();
        }

        @Override
        public Runnable doStuffServer() {
            return () -> {
                ItemStack heldItem = this.player.func_184586_b(EnumHand.MAIN_HAND);
                if (ItemStack.func_77989_b((ItemStack)heldItem, (ItemStack)this.stack) && this.stack.func_77973_b() instanceof ILeftClickHandler) {
                    ((ILeftClickHandler)this.stack.func_77973_b()).leftClick(this.player.field_70170_p, this.player, this.stack);
                }
            };
        }

        static {
            MinecraftForge.EVENT_BUS.register(PacketSendLeftClick.class);
        }
    }
}

