/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.lib;

import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import zabi.minecraft.extraalchemy.lib.Log;

public class Utils {
    private static final Field bis = ReflectionHelper.findField(DragonFightManager.class, (String)"bossInfo", (String)"field_186109_c");
    private static final int MAX_LEVEL = 21862;
    private static final int[] xpmap = new int[21863];

    private Utils() {
    }

    public static void teleportThroughDimensions(EntityPlayer player, int dimension, double x, double y, double z) {
        int oldDimension = player.func_130014_f_().field_73011_w.getDimension();
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
        MinecraftServer server = player.func_130014_f_().func_73046_m();
        WorldServer worldServer = server.func_71218_a(dimension);
        DragonFightManager dfm = null;
        if (player.func_130014_f_().field_73011_w instanceof WorldProviderEnd) {
            dfm = ((WorldProviderEnd)player.func_130014_f_().field_73011_w).func_186063_s();
        }
        player.func_82242_a(0);
        worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(entityPlayerMP, dimension, new Teleporter(worldServer){

            public void func_180266_a(Entity entityIn, float rotationYaw) {
            }
        });
        player.func_70634_a(x, y, z);
        if (oldDimension == 1) {
            if (dfm != null && player instanceof EntityPlayerMP) {
                try {
                    BossInfoServer bossInfo = (BossInfoServer)bis.get(dfm);
                    bossInfo.func_186761_b((EntityPlayerMP)player);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            player.func_70634_a(x, y, z);
            worldServer.func_72838_d((Entity)player);
            worldServer.func_72866_a((Entity)player, false);
        }
    }

    public static int getExperienceForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level > 21862) {
            return Integer.MAX_VALUE;
        }
        return xpmap[level];
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getLevelForExperience(int experience) {
        for (int i = 1; i < xpmap.length; ++i) {
            if (xpmap[i] <= experience) continue;
            return i - 1;
        }
        return xpmap.length;
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)Utils.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = Math.max(0, Utils.getPlayerXP(player) + amount);
        player.field_71068_ca = Utils.getLevelForExperience(experience);
        int expForLevel = Utils.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)Utils.getXpBarCapacity(player.field_71068_ca);
    }

    static {
        int res = 0;
        for (int i = 0; i <= 21862; ++i) {
            if (res < 0) {
                res = Integer.MAX_VALUE;
                Log.e("Internal XP calculation is wrong. Level " + i + " already maxes out.");
            }
            Utils.xpmap[i] = res;
            res += Utils.getXpBarCapacity(i);
        }
    }
}

