/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.packet;

import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.ClientNetworkManager;
import crazypants.enderio.powertools.machine.capbank.packet.PacketCapBank;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNetworkIdResponse
extends PacketCapBank<PacketNetworkIdResponse, IMessage> {
    private int id;

    public PacketNetworkIdResponse() {
    }

    PacketNetworkIdResponse(@Nonnull TileCapBank capBank) {
        super(capBank);
        this.id = capBank.getNetwork() != null ? capBank.getNetwork().getId() : -1;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.id = buf.readInt();
    }

    @Override
    protected IMessage handleMessage(TileCapBank te, PacketNetworkIdResponse message, MessageContext ctx) {
        te.setNetworkId(message.id);
        te.setNetwork(ClientNetworkManager.getInstance().getOrCreateNetwork(message.id));
        return null;
    }
}

