/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.network;

import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.CapBankNetwork;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.util.FuncUtil;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class NetworkUtil {
    private static AtomicInteger nextID = new AtomicInteger((int)(Math.random() * 1000.0));

    public static void ensureValidNetwork(TileCapBank cap) {
        if (!NetworkUtil.reuseNetwork(cap)) {
            new CapBankNetwork(nextID.getAndIncrement()).init(cap);
        }
    }

    public static boolean hasNeigbours(TileCapBank cap) {
        if (!cap.getType().isMultiblock()) {
            return false;
        }
        for (EnumFacing dir : EnumFacing.values()) {
            TileCapBank neighbour;
            TileEntity te = cap.func_145831_w().func_175625_s(cap.func_174877_v().func_177972_a((EnumFacing)NullHelper.notnullJ((Object)dir, (String)"Enum.values()")));
            if (!(te instanceof TileCapBank) || !(neighbour = (TileCapBank)te).canConnectTo(cap)) continue;
            return true;
        }
        return false;
    }

    private static Collection<TileCapBank> getNeigbours(TileCapBank cap) {
        if (!cap.getType().isMultiblock()) {
            return Collections.emptyList();
        }
        ArrayList<TileCapBank> res = new ArrayList<TileCapBank>();
        NetworkUtil.getNeigbours(cap, res);
        return res;
    }

    private static void getNeigbours(TileCapBank cap, Collection<TileCapBank> res) {
        for (EnumFacing dir : EnumFacing.values()) {
            TileCapBank neighbour;
            TileEntity te = cap.func_145831_w().func_175625_s(cap.func_174877_v().func_177972_a((EnumFacing)NullHelper.notnullJ((Object)dir, (String)"Enum.values()")));
            if (!(te instanceof TileCapBank) || !(neighbour = (TileCapBank)te).canConnectTo(cap)) continue;
            res.add(neighbour);
        }
    }

    public static Collection<TileCapBank> getAllNeigbours(TileCapBank cap) {
        if (!cap.getType().isMultiblock()) {
            return Collections.singleton(cap);
        }
        HashSet<TileCapBank> result = new HashSet<TileCapBank>();
        LongRBTreeSet seen = new LongRBTreeSet();
        LinkedList<BlockPos> todo = new LinkedList<BlockPos>();
        todo.add(cap.getLocation());
        while (!todo.isEmpty()) {
            TileCapBank te = (TileCapBank)((Object)FuncUtil.runIf(todo.pop(), next -> (TileCapBank)((Object)((Object)BlockEnder.getAnyTileEntitySafe((IBlockAccess)cap.func_145831_w(), (BlockPos)next, TileCapBank.class)))));
            if (te == null || !te.canConnectTo(cap)) continue;
            result.add(te);
            NNList.NNIterator itr = NNList.FACING.fastIterator();
            while (itr.hasNext()) {
                BlockPos candidate = te.func_174877_v().func_177972_a((EnumFacing)itr.next());
                long long1 = candidate.func_177986_g();
                if (seen.contains(long1)) continue;
                seen.add(long1);
                todo.add(candidate);
            }
        }
        return result;
    }

    private static boolean reuseNetwork(TileCapBank cap) {
        ICapBankNetwork network = null;
        for (TileCapBank conduit : NetworkUtil.getNeigbours(cap)) {
            if (network == null) {
                network = conduit.getNetwork();
                continue;
            }
            if (network == conduit.getNetwork()) continue;
            return false;
        }
        if (network == null) {
            return false;
        }
        cap.setNetwork(network);
        network.addMember(cap);
        return true;
    }
}

