/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.render;

import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.render.registry.TextureRegistry;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ConduitTextureWrapper
implements IConduitTexture {
    @Nonnull
    private static final Vector4f FULL = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
    @Nonnull
    private final TextureAtlasSprite texture;
    @Nonnull
    private final Vector4f uv;

    public ConduitTextureWrapper(@Nonnull TextureAtlasSprite texture, @Nonnull Vector4f uv) {
        this.texture = texture;
        this.uv = uv;
    }

    public ConduitTextureWrapper(@Nonnull TextureAtlasSprite texture, int vOffset) {
        this(texture, new Vector4f(0.0f, (float)(4 * ConduitTextureWrapper.checkOffset(vOffset)) / 16.0f, 0.8125f, (float)(4 * (1 + vOffset)) / 16.0f));
    }

    public ConduitTextureWrapper(@Nonnull TextureAtlasSprite texture) {
        this(texture, FULL);
    }

    private static int checkOffset(int vOffset) {
        if (vOffset < 0 || vOffset > 3) {
            throw new RuntimeException("Invalid vOffset: " + vOffset);
        }
        return vOffset;
    }

    @Nonnull
    public TextureRegistry.TextureSupplier getTexture() {
        return new TextureRegistry.TextureSupplier(){

            @Nonnull
            public <T> T get(@Nonnull Class<T> clazz) {
                return (T)ConduitTextureWrapper.this.texture;
            }
        };
    }

    @Nonnull
    public Vector4f getUv() {
        return this.uv;
    }

    @Nonnull
    public TextureAtlasSprite getSprite() {
        return this.texture;
    }
}

