/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.PacketOpenConduitUI;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.util.Prep;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiExternalConnectionSelector
extends GuiScreen {
    private static int BUTTON_HEIGHT = 20;
    private static int BUTTON_WIDTH = 60;
    Set<EnumFacing> cons;
    IConduitBundle cb;
    EnumMap<EnumFacing, Point> textPositions = new EnumMap(EnumFacing.class);
    EnumMap<EnumFacing, ItemStack> stacks = new EnumMap(EnumFacing.class);
    EnumMap<EnumFacing, Point> stackPositions = new EnumMap(EnumFacing.class);
    EnumMap<EnumFacing, BlockPos> neighborPositions = new EnumMap(EnumFacing.class);
    private long keyLock = Minecraft.func_71386_F() + 2000L;
    private EnumFacing W;
    private EnumFacing S;
    private EnumFacing A;
    private EnumFacing D;
    private float w;
    private float s;
    private float a;
    private float d;
    private boolean won;
    private boolean son;
    private boolean aon;
    private boolean don;
    private boolean jon;
    private boolean con;
    private static final float deg2rad = (float)Math.PI / 180;
    private static final float headg2rad = 1.5707964f;

    public GuiExternalConnectionSelector(IConduitBundle cb) {
        this.cb = cb;
        this.cons = new HashSet<EnumFacing>();
        for (IClientConduit conduit : cb.getClientConduits()) {
            if (ConduitRegistry.getNetwork((IConduit)conduit).canConnectToAnything()) {
                Set conCons = conduit.getConduitConnections();
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (conCons.contains(dir)) continue;
                    this.cons.add(dir);
                }
                continue;
            }
            this.cons.addAll(conduit.getExternalConnections());
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (this.won && keyCode == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.go(this.W);
        } else if (this.son && keyCode == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.go(this.S);
        } else if (this.aon && keyCode == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.go(this.A);
        } else if (this.don && keyCode == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.go(this.D);
        } else if (this.jon && keyCode == this.field_146297_k.field_71474_y.field_74314_A.func_151463_i()) {
            this.go(EnumFacing.UP);
        } else if (this.con && keyCode == this.field_146297_k.field_71474_y.field_74311_E.func_151463_i() && this.keyLock < Minecraft.func_71386_F()) {
            this.go(EnumFacing.DOWN);
        }
    }

    protected void func_146284_a(@Nonnull GuiButton b) {
        EnumFacing dir = EnumFacing.values()[b.field_146127_k];
        this.go(dir);
    }

    private void go(EnumFacing dir) {
        if (dir != null) {
            if (this.neighborPositions.containsKey(dir)) {
                BlockPos goPos = this.neighborPositions.get(dir);
                double d0 = (double)goPos.func_177958_n() + 0.5 - this.field_146297_k.field_71439_g.field_70165_t;
                double d2 = (double)goPos.func_177952_p() + 0.5 - this.field_146297_k.field_71439_g.field_70161_v;
                double d1 = (double)goPos.func_177956_o() + 0.5 - (this.field_146297_k.field_71439_g.field_70163_u + (double)this.field_146297_k.field_71439_g.func_70047_e());
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                this.field_146297_k.field_71439_g.field_70125_A = MathHelper.func_76142_g((float)((float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232))));
                this.field_146297_k.field_71439_g.field_70177_z = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f));
                ConduitRegistry.getConduitModObjectNN().openClientGui((World)this.field_146297_k.field_71441_e, goPos, (EntityPlayer)this.field_146297_k.field_71439_g, null, 0);
            } else {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenConduitUI(this.cb.getEntity(), dir));
            }
        }
    }

    protected void findBlockDataForDirection(@Nonnull EnumFacing direction) {
        BlockPos blockPos;
        World world = this.cb.getBundleworld();
        if (!world.func_175623_d(blockPos = this.cb.getLocation().func_177972_a(direction))) {
            IBlockState bs = world.func_180495_p(blockPos);
            Block b = bs.func_177230_c();
            if (b != ConduitRegistry.getConduitModObjectNN().getBlock()) {
                try {
                    ItemStack pickBlock = b.getPickBlock(bs, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), direction.func_176734_d(), blockPos), world, blockPos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    if (Prep.isValid((ItemStack)pickBlock)) {
                        this.stacks.put(direction, pickBlock);
                        return;
                    }
                }
                catch (Throwable pickBlock) {
                    // empty catch block
                }
                try {
                    Item item = b.func_180660_a(bs.func_185899_b((IBlockAccess)world, blockPos), world.field_73012_v, 0);
                    if (NullHelper.untrust((Object)item) != null) {
                        this.stacks.put(direction, new ItemStack(item, 1, b.func_180651_a(bs)));
                    }
                }
                catch (Throwable item) {}
            } else {
                this.neighborPositions.put(direction, blockPos);
                this.stacks.put(direction, new ItemStack(ModObject.itemConduitFacade.getItemNN()));
                TileEntity te = world.func_175625_s(blockPos);
                if (te instanceof IConduitBundle) {
                    IConduitBundle conduit = (IConduitBundle)te;
                    for (IClientConduit next : conduit.getClientConduits()) {
                        if (next == null) continue;
                        this.stacks.put(direction, next.createItem());
                        break;
                    }
                }
            }
        }
    }

    public void func_73866_w_() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            GuiButton b;
            if (dir == null) continue;
            this.findBlockDataForDirection(dir);
            Point p = this.getOffsetForDir(dir, this.cons.contains(dir) || this.neighborPositions.containsKey(dir));
            if (this.neighborPositions.containsKey(dir)) {
                this.textPositions.put(dir, new Point(-3000, -3000));
                int offset = (BUTTON_WIDTH - BUTTON_HEIGHT) / 2;
                this.stackPositions.put(dir, new Point(p.x + 2 + offset, p.y + 2));
                b = new GuiButton(dir.ordinal(), p.x + offset, p.y, BUTTON_HEIGHT, BUTTON_HEIGHT, "");
                this.field_146292_n.add(b);
                continue;
            }
            this.textPositions.put(dir, new Point(p.x, p.y + BUTTON_HEIGHT + 1));
            this.stackPositions.put(dir, new Point(p.x + 2, p.y + 2));
            b = new GuiButton(dir.ordinal(), p.x, p.y, BUTTON_WIDTH, BUTTON_HEIGHT, (this.stacks.containsKey(dir) ? "  " : "") + dir.toString());
            this.field_146292_n.add(b);
            if (this.cons.contains(dir)) continue;
            b.field_146124_l = false;
            if (dir.func_96559_d() == 0 || this.stacks.containsKey(dir)) continue;
            b.field_146125_m = false;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        int scale = this.field_146289_q.func_82883_a() ? 1 : 2;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.stacks.containsKey(dir)) continue;
            ItemStack stack = this.stacks.get(dir);
            String blockName = stack.func_82833_r();
            int textWidth = this.field_146289_q.func_78256_a(blockName) / scale;
            Point p = this.textPositions.get(dir);
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / (float)scale), (float)(1.0f / (float)scale), (float)(1.0f / (float)scale));
            this.func_73731_b(this.field_146289_q, blockName, scale * (p.x + BUTTON_WIDTH / 2 - textWidth / 2), scale * p.y, ColorUtil.getARGB((Color)Color.gray));
            GL11.glPopMatrix();
        }
        super.func_73863_a(par1, par2, par3);
        String txt = "Select Connection to Adjust";
        int x = this.field_146294_l / 2 - this.field_146289_q.func_78256_a(txt) / 2;
        int y = this.field_146295_m / 2 - BUTTON_HEIGHT * 3 - 5;
        this.func_73731_b(this.field_146289_q, txt, x, y, ColorUtil.getARGB((Color)Color.white));
        if (Minecraft.func_71410_x().field_71439_g.func_70005_c_().contains("direwolf20") && (EnderIO.proxy.getTickCount() / 16L & 1L) == 1L) {
            txt = "You can also right-click the connector directly";
            x = this.field_146294_l / 2 - this.field_146289_q.func_78256_a(txt) / 2;
            y = (int)((double)(this.field_146295_m / 2) + (double)BUTTON_HEIGHT * 2.75 - 5.0);
            this.func_73731_b(this.field_146289_q, txt, x, y, ColorUtil.getARGB((Color)Color.white));
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.stacks.containsKey(dir)) continue;
            ItemStack stack = this.stacks.get(dir);
            Point p = this.stackPositions.get(dir);
            if (stack == null) continue;
            this.field_146296_j.func_180450_b(stack, p.x, p.y);
        }
    }

    private Point getOffsetForDir(EnumFacing dir, boolean enabled) {
        int mx = this.field_146294_l / 2;
        int my = this.field_146295_m / 2;
        if (dir.func_96559_d() == 0) {
            float playerAngle = Minecraft.func_71410_x().field_71439_g.field_70177_z * ((float)Math.PI / 180);
            float dirAngle = (float)dir.func_176736_b() * 1.5707964f;
            float buttonAngle = dirAngle - playerAngle - 1.5707964f;
            int ax = (int)(MathHelper.func_76134_b((float)buttonAngle) * (float)BUTTON_WIDTH);
            int ay = (int)(MathHelper.func_76126_a((float)buttonAngle) * (float)BUTTON_HEIGHT * 2.0f);
            int x = mx - BUTTON_WIDTH / 2 + ax;
            int y = my - BUTTON_HEIGHT / 2 + ay;
            if ((float)ay < this.w) {
                this.W = dir;
                this.won = enabled;
                this.w = ay;
            }
            if ((float)ay > this.s) {
                this.S = dir;
                this.son = enabled;
                this.s = ay;
            }
            if ((float)ax < this.a) {
                this.A = dir;
                this.aon = enabled;
                this.a = ax;
            }
            if ((float)ax > this.d) {
                this.D = dir;
                this.don = enabled;
                this.d = ax;
            }
            return new Point(x, y);
        }
        int x = mx - BUTTON_WIDTH / 2;
        int y = (int)((double)(my - BUTTON_HEIGHT / 2) - ((double)(dir.func_96559_d() * 4) + 0.5) * (double)BUTTON_HEIGHT);
        if (dir == EnumFacing.DOWN) {
            this.con = enabled;
        } else {
            this.jon = enabled;
        }
        return new Point(x, y);
    }
}

