/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.ConduitTank;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractTankConduit
extends AbstractLiquidConduit {
    protected ConduitTank tank = new ConduitTank(0);
    protected boolean stateDirty = false;
    protected long lastEmptyTick = 0L;
    protected int numEmptyEvents = 0;
    protected boolean fluidTypeLocked = false;
    private int lastLightValue;

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return false;
        }
        AbstractTankConduitNetwork<? extends AbstractTankConduit> network = this.getTankNetwork();
        if (ToolUtil.isToolEquipped((EntityPlayer)player, (EnumHand)hand)) {
            CollidableComponent component;
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && (component = res.component) != null) {
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (component.isCore()) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(faceHit);
                    ILiquidConduit liquidConduit = (ILiquidConduit)ConduitUtil.getConduit((World)this.getBundle().getEntity().func_145831_w(), (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p(), ILiquidConduit.class);
                    if (!(liquidConduit instanceof AbstractTankConduit) || !this.canJoinNeighbour(liquidConduit)) {
                        return false;
                    }
                    AbstractTankConduit neighbour = (AbstractTankConduit)liquidConduit;
                    if (neighbour.getFluidType() != null) {
                        this.setFluidTypeOnNetwork(this, neighbour.getFluidType());
                    } else if (this.getFluidType() != null) {
                        neighbour.setFluidTypeOnNetwork(neighbour, this.getFluidType());
                    }
                    return ConduitUtil.connectConduits((IServerConduit)this, (EnumFacing)faceHit);
                }
                EnumFacing connDir = component.getDirection();
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    FluidStack curFluidType = null;
                    if (this.getTankNetwork() != null) {
                        curFluidType = this.getTankNetwork().getFluidType();
                    }
                    ConduitUtil.disconnectConduits((IServerConduit)this, (EnumFacing)connDir);
                    this.setFluidType(curFluidType);
                }
            }
            return true;
        }
        if (heldItem.func_77973_b() == Items.field_151133_ar) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && network != null) {
                long curTick = this.getBundle().getEntity().func_145831_w().func_82737_E();
                this.numEmptyEvents = curTick - this.lastEmptyTick < 20L ? ++this.numEmptyEvents : 1;
                this.lastEmptyTick = curTick;
                if (this.numEmptyEvents < 2) {
                    if (network.fluidTypeLocked) {
                        network.setFluidTypeLocked(false);
                        this.numEmptyEvents = 0;
                        player.func_146105_b((ITextComponent)Lang.ITEM_LIQUID_CONDUIT_UNLOCKED_TYPE.toChatServer(), true);
                    }
                } else {
                    network.setFluidType(null);
                    this.numEmptyEvents = 0;
                }
            }
            return true;
        }
        FluidStack fluid = FluidUtil.getFluidTypeFromItem((ItemStack)heldItem);
        if (fluid != null) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && network != null && (network.getFluidType() == null || network.getTotalVolume() < 500 || LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), fluid))) {
                network.setFluidType(fluid);
                network.setFluidTypeLocked(true);
                player.func_146105_b((ITextComponent)new TextComponentTranslation(EnderIO.lang.addPrefix("itemLiquidConduit.lockedType"), new Object[]{fluid.getLocalizedName()}), true);
            }
            return true;
        }
        return false;
    }

    void setFluidTypeLocked(boolean fluidTypeLocked) {
        if (fluidTypeLocked == this.fluidTypeLocked) {
            return;
        }
        this.fluidTypeLocked = fluidTypeLocked;
        this.stateDirty = true;
    }

    private void setFluidTypeOnNetwork(AbstractTankConduit con, FluidStack type) {
        IConduitNetwork n = con.getNetwork();
        if (n != null) {
            AbstractTankConduitNetwork network = (AbstractTankConduitNetwork)n;
            network.setFluidType(type);
        }
    }

    protected abstract boolean canJoinNeighbour(ILiquidConduit var1);

    public abstract AbstractTankConduitNetwork<? extends AbstractTankConduit> getTankNetwork();

    public void setFluidType(FluidStack liquidType) {
        if (this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(liquidType)) {
            return;
        }
        if (liquidType != null) {
            liquidType = liquidType.copy();
        } else if (this.tank.getFluid() == null) {
            return;
        }
        this.tank.setLiquid(liquidType);
        this.stateDirty = true;
    }

    public ConduitTank getTank() {
        return this.tank;
    }

    public FluidStack getFluidType() {
        FluidStack result = null;
        if (this.getTankNetwork() != null) {
            result = this.getTankNetwork().getFluidType();
        }
        if (result == null) {
            result = this.tank.getFluid();
        }
        return result;
    }

    public boolean isFluidTypeLocked() {
        return this.fluidTypeLocked;
    }

    @Override
    public void updateEntity(@Nonnull World world) {
        int lightValue;
        if (((Boolean)ConduitConfig.dynamicLighting.get()).booleanValue() && this.lastLightValue != (lightValue = this.getLightValue())) {
            BlockPos pos = this.getBundle().getLocation();
            this.getBundle().getBundleworld().func_180500_c(EnumSkyBlock.BLOCK, pos);
            this.lastLightValue = lightValue;
        }
        super.updateEntity(world);
    }

    @Override
    public int getLightValue() {
        FluidStack stack = this.getFluidType();
        return stack == null || stack.amount <= 0 ? 0 : stack.getFluid().getLuminosity(stack);
    }

    protected abstract void updateTank();

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.updateTank();
        if (nbtRoot.func_74764_b("tank")) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtRoot.func_74775_l("tank"));
            this.tank.setLiquid(liquid);
        } else {
            this.tank.setLiquid(null);
        }
        this.fluidTypeLocked = nbtRoot.func_74767_n("fluidLocked");
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        FluidStack ft = this.getFluidType();
        if (ConduitUtil.isFluidValid((FluidStack)ft)) {
            this.updateTank();
            ft = ft.copy();
            ft.amount = this.tank.getFluidAmount();
            nbtRoot.func_74782_a("tank", (NBTBase)ft.writeToNBT(new NBTTagCompound()));
        }
        nbtRoot.func_74757_a("fluidLocked", this.fluidTypeLocked);
    }

    @Override
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        if (this.fluidTypeLocked) {
            hashCodes.add(1);
        }
    }

    @Override
    public boolean canFill(EnumFacing side, FluidStack fluid) {
        if (this.getNetwork() == null || !this.getConnectionMode(side).acceptsInput()) {
            return false;
        }
        return this.canExtractFromDir(side) && LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), fluid);
    }

    @Override
    public boolean canDrain(EnumFacing side, FluidStack fluid) {
        if (this.getNetwork() == null || !this.getConnectionMode(side).acceptsOutput()) {
            return false;
        }
        return this.canInputToDir(side) && LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), fluid);
    }
}

