/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.ILocalizable;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.conduits.conduit.IConduitComponent;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractConduit
implements IServerConduit,
IClientConduit.WithDefaultRendering,
IConduitComponent,
INotifier {
    @Nonnull
    protected final Set<EnumFacing> conduitConnections = EnumSet.noneOf(EnumFacing.class);
    @Nonnull
    protected final Set<EnumFacing> externalConnections = EnumSet.noneOf(EnumFacing.class);
    public static final float TRANSMISSION_SCALE = 0.3f;
    @Nullable
    protected IConduitBundle bundle;
    protected boolean active;
    protected List<CollidableComponent> collidables;
    @Nonnull
    protected final EnumMap<EnumFacing, ConnectionMode> conectionModes = new EnumMap(EnumFacing.class);
    protected boolean collidablesDirty = true;
    private boolean clientStateDirty = true;
    private boolean dodgyChangeSinceLastCallFlagForBundle = true;
    protected boolean connectionsDirty = true;
    protected boolean readFromNbt = false;
    private Integer lastExternalRedstoneLevel = null;
    private boolean hasNetwork = true;
    private long nextNetworkTry = -1L;

    protected AbstractConduit() {
    }

    public boolean writeConnectionSettingsToNBT(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound nbt) {
        if (!this.getExternalConnections().contains(dir)) {
            return false;
        }
        NBTTagCompound dataRoot = this.getNbtRootForType(nbt, true);
        dataRoot.func_74777_a("connectionMode", (short)this.getConnectionMode(dir).ordinal());
        this.writeTypeSettingsToNbt(dir, dataRoot);
        return true;
    }

    public boolean readConduitSettingsFromNBT(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound nbt) {
        if (!this.getExternalConnections().contains(dir) && !this.canConnectToExternal(dir, true)) {
            return false;
        }
        NBTTagCompound dataRoot = this.getNbtRootForType(nbt, false);
        if (dataRoot == null) {
            return false;
        }
        if (dataRoot.func_74764_b("connectionMode")) {
            ConnectionMode mode = (ConnectionMode)NullHelper.first((Object[])new ConnectionMode[]{ConnectionMode.values()[dataRoot.func_74765_d("connectionMode")], this.getDefaultConnectionMode()});
            this.setConnectionMode(dir, mode);
        }
        this.readTypeSettings(dir, dataRoot);
        this.getBundle().dirty();
        return true;
    }

    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
    }

    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
    }

    protected NBTTagCompound getNbtRootForType(@Nonnull NBTTagCompound nbt, boolean createIfNull) {
        Class bt = this.getBaseConduitType();
        String dataRootName = (String)NullHelper.notnullJ((Object)bt.getSimpleName(), (String)"Class#getSimpleName");
        NBTTagCompound dataRoot = null;
        if (nbt.func_74764_b(dataRootName)) {
            dataRoot = nbt.func_74775_l(dataRootName);
        }
        if (dataRoot == null && createIfNull) {
            dataRoot = new NBTTagCompound();
            nbt.func_74782_a(dataRootName, (NBTBase)dataRoot);
        }
        return dataRoot;
    }

    @Nonnull
    public ConnectionMode getConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode res = this.conectionModes.get(dir);
        if (res == null) {
            return this.getDefaultConnectionMode();
        }
        return res;
    }

    @Nonnull
    protected ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.INPUT;
    }

    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        ConnectionMode oldVal = this.conectionModes.get(dir);
        if (oldVal == mode) {
            return;
        }
        if (mode == this.getDefaultConnectionMode()) {
            this.conectionModes.remove(dir);
        } else {
            this.conectionModes.put(dir, mode);
        }
        this.connectionsChanged();
    }

    public boolean supportsConnectionMode(@Nonnull ConnectionMode mode) {
        if (mode == this.getDefaultConnectionMode() && this.conectionModes.size() != 6) {
            return true;
        }
        for (ConnectionMode cm : this.conectionModes.values()) {
            if (cm != mode) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public ConnectionMode getNextConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode curMode = this.getConnectionMode(dir);
        ConnectionMode next = ConnectionMode.getNext((ConnectionMode)curMode);
        if (next == ConnectionMode.NOT_SET) {
            next = ConnectionMode.IN_OUT;
        }
        return next;
    }

    @Nonnull
    public ConnectionMode getPreviousConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode curMode = this.getConnectionMode(dir);
        ConnectionMode prev = ConnectionMode.getPrevious((ConnectionMode)curMode);
        if (prev == ConnectionMode.NOT_SET) {
            prev = ConnectionMode.DISABLED;
        }
        return prev;
    }

    public boolean haveCollidablesChangedSinceLastCall() {
        if (this.dodgyChangeSinceLastCallFlagForBundle) {
            this.dodgyChangeSinceLastCallFlagForBundle = false;
            return true;
        }
        return false;
    }

    public void setBundle(@Nullable IConduitBundle tileConduitBundle) {
        this.bundle = tileConduitBundle;
    }

    @Nonnull
    public IConduitBundle getBundle() {
        return (IConduitBundle)NullHelper.notnull((Object)this.bundle, (String)"Logic error in conduit---no bundle set");
    }

    @Nonnull
    public Set<EnumFacing> getConduitConnections() {
        return this.conduitConnections;
    }

    public boolean containsConduitConnection(@Nonnull EnumFacing dir) {
        return this.conduitConnections.contains(dir);
    }

    public void conduitConnectionAdded(@Nonnull EnumFacing fromDirection) {
        this.conduitConnections.add(fromDirection);
    }

    public void conduitConnectionRemoved(@Nonnull EnumFacing fromDirection) {
        this.conduitConnections.remove(fromDirection);
    }

    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit conduit) {
        return this.getConnectionMode(direction) != ConnectionMode.DISABLED && conduit.getConnectionMode(direction.func_176734_d()) != ConnectionMode.DISABLED;
    }

    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionMode) {
        return false;
    }

    @Nonnull
    public Set<EnumFacing> getExternalConnections() {
        return this.externalConnections;
    }

    public boolean hasExternalConnections() {
        return !this.externalConnections.isEmpty();
    }

    public boolean hasConduitConnections() {
        return !this.conduitConnections.isEmpty();
    }

    public boolean containsExternalConnection(@Nonnull EnumFacing dir) {
        return this.externalConnections.contains(dir);
    }

    public void externalConnectionAdded(@Nonnull EnumFacing fromDirection) {
        this.externalConnections.add(fromDirection);
    }

    public void externalConnectionRemoved(@Nonnull EnumFacing fromDirection) {
        this.externalConnections.remove(fromDirection);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active != this.active) {
            this.clientStateDirty = true;
        }
        this.active = active;
    }

    public void writeToNBT(@Nonnull NBTTagCompound conduitBody) {
        int i;
        int[] dirs = new int[this.conduitConnections.size()];
        Iterator<EnumFacing> cons = this.conduitConnections.iterator();
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = cons.next().ordinal();
        }
        conduitBody.func_74783_a("connections", dirs);
        dirs = new int[this.externalConnections.size()];
        cons = this.externalConnections.iterator();
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = cons.next().ordinal();
        }
        conduitBody.func_74783_a("externalConnections", dirs);
        conduitBody.func_74757_a("signalActive", this.active);
        if (this.conectionModes.size() > 0) {
            byte[] modes = new byte[6];
            int i2 = 0;
            NNList.NNIterator itr = NNList.FACING.fastIterator();
            while (itr.hasNext()) {
                modes[i2] = (byte)this.getConnectionMode((EnumFacing)itr.next()).ordinal();
                ++i2;
            }
            conduitBody.func_74773_a("conModes", modes);
        }
        conduitBody.func_74757_a("hasNetwork", this.getNetwork() != null || this.nextNetworkTry == -1L);
    }

    public void readFromNBT(@Nonnull NBTTagCompound conduitBody) {
        int i;
        this.conduitConnections.clear();
        int[] dirs = conduitBody.func_74759_k("connections");
        for (i = 0; i < dirs.length; ++i) {
            this.conduitConnections.add(EnumFacing.values()[dirs[i]]);
        }
        this.externalConnections.clear();
        dirs = conduitBody.func_74759_k("externalConnections");
        for (i = 0; i < dirs.length; ++i) {
            this.externalConnections.add(EnumFacing.values()[dirs[i]]);
        }
        this.active = conduitBody.func_74767_n("signalActive");
        this.conectionModes.clear();
        byte[] modes = conduitBody.func_74770_j("conModes");
        if (modes.length == 6) {
            int i2 = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.conectionModes.put(dir, ConnectionMode.values()[modes[i2]]);
                ++i2;
            }
        }
        this.hasNetwork = conduitBody.func_74767_n("hasNetwork");
        this.readFromNbt = true;
    }

    public int getLightValue() {
        return 0;
    }

    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        return false;
    }

    public float getSelfIlluminationForState(@Nonnull CollidableComponent component) {
        return this.isActive() ? 1.0f : 0.0f;
    }

    public float getTransmitionGeometryScale() {
        return 0.3f;
    }

    public void onChunkUnload() {
        IConduitNetwork network = this.getNetwork();
        if (network != null) {
            network.destroyNetwork();
        }
    }

    public void updateEntity(@Nonnull World world) {
        if (world.field_72995_K) {
            return;
        }
        Prof.start((IBlockAccess)world, (String)"updateNetwork");
        this.updateNetwork(world);
        Prof.next((IBlockAccess)world, (String)"updateConnections");
        this.updateConnections();
        this.readFromNbt = false;
        if (this.clientStateDirty) {
            this.getBundle().dirty();
            this.clientStateDirty = false;
        }
        Prof.stop((IBlockAccess)world);
    }

    private void updateConnections() {
        EnumFacing dir;
        if (!this.connectionsDirty && !this.readFromNbt) {
            return;
        }
        boolean externalConnectionsChanged = false;
        NNList copy = new NNList(this.externalConnections);
        NNList.NNIterator itr = copy.fastIterator();
        while (itr.hasNext()) {
            dir = (EnumFacing)itr.next();
            if (this.canConnectToExternal(dir, false) && !this.readFromNbt) continue;
            this.externalConnectionRemoved(dir);
            externalConnectionsChanged = true;
        }
        itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            dir = (EnumFacing)itr.next();
            if (this.conduitConnections.contains(dir) || this.externalConnections.contains(dir) || !this.canConnectToExternal(dir, false)) continue;
            this.externalConnectionAdded(dir);
            externalConnectionsChanged = true;
        }
        if (externalConnectionsChanged) {
            this.connectionsChanged();
        }
        this.connectionsDirty = false;
    }

    public void connectionsChanged() {
        this.collidablesDirty = true;
        this.clientStateDirty = true;
        this.dodgyChangeSinceLastCallFlagForBundle = true;
    }

    protected void setClientStateDirty() {
        this.clientStateDirty = true;
    }

    protected void updateNetwork(World world) {
        long tickCount = EnderIO.proxy.getServerTickCount();
        if (tickCount < this.nextNetworkTry && this.getNetwork() == null) {
            return;
        }
        if (this.getNetwork() == null) {
            BlockPos pos = this.getBundle().getLocation();
            if (world.func_175667_e(pos)) {
                ConduitUtil.ensureValidNetwork((IServerConduit)this);
                IConduitNetwork network = this.getNetwork();
                if (network != null) {
                    this.nextNetworkTry = -1L;
                    network.sendBlockUpdatesForEntireNetwork();
                    if (this.readFromNbt) {
                        this.connectionsChanged();
                    }
                } else {
                    this.setNetworkBuildFailed();
                }
            }
        } else if (this.nextNetworkTry > -1L) {
            this.nextNetworkTry = -1L;
            this.setClientStateDirty();
        }
    }

    public void setNetworkBuildFailed() {
        if (this.nextNetworkTry == -1L) {
            this.setClientStateDirty();
        }
        this.nextNetworkTry = EnderIO.proxy.getServerTickCount() + 200L + (long)(Math.random() * 100.0);
    }

    @Nonnull
    public Set<? extends ILocalizable> getNotification() {
        HashSet<1> result = new HashSet<1>();
        if (this.nextNetworkTry > -1L) {
            result.add(new ILocalizable(){

                @Nonnull
                public String getUnlocalizedName() {
                    return Lang.GUI_NETWORK_PARTIALLY_UNLOADED.getKey();
                }
            });
        }
        return result;
    }

    @Nonnull
    public NNList<ITextComponent> getConduitProbeInformation(@Nonnull EntityPlayer player) {
        NNList result = new NNList();
        if (this.nextNetworkTry > -1L) {
            result.add((Object)Lang.GUI_NETWORK_PARTIALLY_UNLOADED.toChatServer().func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        return result;
    }

    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        return true;
    }

    public void onAddedToBundle() {
        EnumFacing dir;
        TileEntity te = this.getBundle().getEntity();
        World world = te.func_145831_w();
        this.conduitConnections.clear();
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            dir = (EnumFacing)itr.next();
            IConduit neighbour = ConduitUtil.getConduit((World)world, (TileEntity)te, (EnumFacing)dir, (Class)this.getBaseConduitType());
            if (!(neighbour instanceof IServerConduit) || !((IServerConduit)neighbour).canConnectToConduit(dir.func_176734_d(), (IConduit)this) || !this.canConnectToConduit(dir, neighbour)) continue;
            this.conduitConnections.add(dir);
            ((IServerConduit)neighbour).conduitConnectionAdded(dir.func_176734_d());
            ((IServerConduit)neighbour).connectionsChanged();
        }
        this.externalConnections.clear();
        itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            dir = (EnumFacing)itr.next();
            if (this.containsConduitConnection(dir) || !this.canConnectToExternal(dir, false)) continue;
            this.externalConnectionAdded(dir);
        }
        this.connectionsChanged();
    }

    public void onAfterRemovedFromBundle() {
        TileEntity te = this.getBundle().getEntity();
        World world = te.func_145831_w();
        for (EnumFacing dir : this.conduitConnections) {
            IConduit neighbour;
            if (dir == null || !((neighbour = ConduitUtil.getConduit((World)world, (TileEntity)te, (EnumFacing)dir, (Class)this.getBaseConduitType())) instanceof IServerConduit)) continue;
            ((IServerConduit)neighbour).conduitConnectionRemoved(dir.func_176734_d());
            ((IServerConduit)neighbour).connectionsChanged();
        }
        this.conduitConnections.clear();
        if (!this.externalConnections.isEmpty()) {
            world.func_175685_c(te.func_174877_v(), te.func_145838_q(), true);
        }
        this.externalConnections.clear();
        IConduitNetwork network = this.getNetwork();
        if (network != null) {
            network.destroyNetwork();
        }
        this.connectionsChanged();
    }

    public boolean onNeighborBlockChange(@Nonnull Block block) {
        if (block == ConduitRegistry.getConduitModObjectNN().getBlock()) {
            return false;
        }
        this.lastExternalRedstoneLevel = null;
        EnumSet<EnumFacing> newCons = EnumSet.noneOf(EnumFacing.class);
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            if (this.containsConduitConnection(dir) || !this.canConnectToExternal(dir, false)) continue;
            newCons.add(dir);
        }
        if (newCons.size() != this.externalConnections.size()) {
            this.connectionsDirty = true;
            return true;
        }
        for (EnumFacing dir : this.externalConnections) {
            if (newCons.remove(dir)) continue;
            this.connectionsDirty = true;
            return true;
        }
        if (!newCons.isEmpty()) {
            this.connectionsDirty = true;
            return true;
        }
        return false;
    }

    public boolean onNeighborChange(@Nonnull BlockPos neighbourPos) {
        return false;
    }

    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        return (Collection)NullHelper.notnullJ(Collections.singletonList(new CollidableComponent(this.getCollidableType(), ConduitGeometryUtil.getInstance().getBoundingBox(this.getBaseConduitType(), key.dir, key.offset), key.dir, null)), (String)"Collections#singletonList");
    }

    @Nonnull
    public Class<? extends IConduit> getCollidableType() {
        return this.getBaseConduitType();
    }

    @Nonnull
    public List<CollidableComponent> getCollidableComponents() {
        if (this.collidables != null && !this.collidablesDirty) {
            return this.collidables;
        }
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            Collection<CollidableComponent> col = this.getCollidables(dir);
            if (col == null) continue;
            result.addAll(col);
        }
        this.collidables = result;
        this.collidablesDirty = false;
        return result;
    }

    private Collection<CollidableComponent> getCollidables(@Nonnull EnumFacing dir) {
        CollidableCache cc = CollidableCache.instance;
        Class<? extends IConduit> type = this.getCollidableType();
        if (this.isConnectedTo(dir) && this.getConnectionMode(dir) != ConnectionMode.DISABLED) {
            return cc.getCollidables(cc.createKey(type, this.getBundle().getOffset(this.getBaseConduitType(), dir), dir), (IConduit)this);
        }
        return null;
    }

    public boolean shouldMirrorTexture() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        hashCodes.add(this.getClass());
        hashCodes.add(this.conduitConnections, this.externalConnections, this.conectionModes);
        hashCodes.add(this.hasNetwork);
    }

    public void invalidate() {
    }

    public int getExternalRedstoneLevel() {
        if (this.lastExternalRedstoneLevel == null) {
            if (this.bundle == null) {
                return 0;
            }
            TileEntity te = this.getBundle().getEntity();
            this.lastExternalRedstoneLevel = ConduitUtil.isBlockIndirectlyGettingPoweredIfLoaded((World)te.func_145831_w(), (BlockPos)te.func_174877_v());
        }
        return this.lastExternalRedstoneLevel;
    }

    public boolean renderError() {
        return !this.hasNetwork;
    }

    public String toString() {
        return "AbstractConduit [getClass()=" + this.getClass() + ", lastExternalRedstoneLevel=" + this.lastExternalRedstoneLevel + ", getConduitConnections()=" + this.getConduitConnections() + ", getExternalConnections()=" + this.getExternalConnections() + ", getNetwork()=" + this.getNetwork() + "]";
    }
}

