/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;

public class SparseArray {
    private static final int GROWTH = 10;
    private int[] keys;
    private int[] data;
    private int size;

    public SparseArray() {
        this(null);
    }

    public int get(int key) {
        int i = Arrays.binarySearch(this.keys, 0, this.size, key);
        if (i < 0 || this.data[i] <= 0) {
            return 0;
        }
        return this.data[i];
    }

    public void delete(int key) {
        int i = Arrays.binarySearch(this.keys, 0, this.size, key);
        if (i >= 0) {
            this.data[i] = 0;
        }
    }

    public void put(int key, int value) {
        int i = Arrays.binarySearch(this.keys, 0, this.size, key);
        if (i < 0) {
            if ((i ^= 0xFFFFFFFF) >= this.size) {
                if (this.size >= this.keys.length) {
                    this.keys = Arrays.copyOf(this.keys, this.size + 10);
                    this.data = Arrays.copyOf(this.data, this.size + 10);
                }
                ++this.size;
            } else if (this.data[i] != 0) {
                int[] newKeys = new int[this.size + 10];
                System.arraycopy(this.keys, 0, newKeys, 0, i);
                System.arraycopy(this.keys, i, newKeys, i + 1, this.size - i);
                this.keys = newKeys;
                int[] newData = new int[this.size + 10];
                System.arraycopy(this.data, 0, newData, 0, i);
                System.arraycopy(this.data, i, newData, i + 1, this.size - i);
                this.data = newData;
                ++this.size;
            }
        }
        this.keys[i] = key;
        this.data[i] = value;
    }

    public NBTTagCompound toNBT() {
        if (this.size > 0) {
            int[] k = new int[this.size];
            int[] v = new int[this.size];
            int idx = 0;
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] <= 0) continue;
                k[idx] = this.keys[i];
                v[idx] = this.data[i];
                ++idx;
            }
            if (idx == 0) {
                this.size = 0;
            } else {
                NBTTagCompound result = new NBTTagCompound();
                result.func_74783_a("k", Arrays.copyOf(k, idx));
                result.func_74783_a("v", Arrays.copyOf(v, idx));
                return result;
            }
        }
        return null;
    }

    public SparseArray(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_74764_b("k") || !nbt.func_74764_b("v")) {
            this.keys = new int[10];
            this.data = new int[10];
            this.size = 0;
        } else {
            this.keys = nbt.func_74759_k("k");
            this.data = nbt.func_74759_k("v");
            this.size = this.keys.length;
        }
    }
}

