/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class O2OMap<K, V>
implements Map<K, V> {
    @Nonnull
    private final Map<K, V> keyMap = new HashMap();
    @Nonnull
    private final Map<V, K> valueMap = new HashMap<V, K>();

    @Override
    public int size() {
        return this.keyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueMap.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.keyMap.get(key);
    }

    public V getValue(K key) {
        return this.keyMap.get(key);
    }

    public K getKey(V key) {
        return this.valueMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        K key2 = this.valueMap.get(value);
        V value2 = this.keyMap.get(key);
        this.valueMap.remove(value2);
        this.keyMap.remove(key2);
        this.valueMap.put(value, key);
        this.keyMap.put(key, value);
        return value2;
    }

    public V putNoOverride(K key, V value) {
        K key2 = this.valueMap.get(value);
        if (key2 != null) {
            throw new RuntimeException("value " + value + " already is mapped to key " + key2);
        }
        V value2 = this.keyMap.get(key);
        if (value2 != null) {
            throw new RuntimeException("key " + key + " already is mapped to value " + value2);
        }
        this.valueMap.put(value, key);
        this.keyMap.put(key, value);
        return value2;
    }

    @Override
    public V remove(Object key) {
        V value = this.keyMap.get(key);
        this.valueMap.remove(value);
        this.keyMap.remove(key);
        return value;
    }

    public V removeKey(K key) {
        V value = this.keyMap.get(key);
        this.valueMap.remove(value);
        this.keyMap.remove(key);
        return value;
    }

    public K removeValue(V value) {
        K key = this.valueMap.get(value);
        this.keyMap.remove(key);
        this.valueMap.remove(value);
        return key;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAllValues(Map<? extends V, ? extends K> m) {
        for (Map.Entry<V, K> entry : m.entrySet()) {
            this.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public void clear() {
        this.keyMap.clear();
        this.valueMap.clear();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

