/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.power.PowerHandlerUtil;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerDistributor
implements NNList.Callback<EnumFacing> {
    @Nonnull
    private final NNList<IEnergyStorage> receptors = new NNList();
    private ListIterator<IEnergyStorage> receptorIterator = this.receptors.listIterator();
    private boolean receptorsDirty = true;
    @Nonnull
    private final BlockPos bc;
    private TileEntity transmitter;

    public PowerDistributor(@Nonnull BlockPos bc) {
        this.bc = bc;
    }

    public void neighboursChanged() {
        this.receptorsDirty = true;
    }

    public int transmitEnergy(@Nonnull World world, int available) {
        this.checkReceptors(world);
        if (this.receptors.isEmpty()) {
            return 0;
        }
        int transmitted = 0;
        int numReceptors = this.receptors.size();
        for (int appliedCount = 0; available > 0 && appliedCount < numReceptors; ++appliedCount) {
            if (!this.receptorIterator.hasNext()) {
                this.receptorIterator = this.receptors.listIterator();
            }
            int used = this.receptorIterator.next().receiveEnergy(available, false);
            transmitted += used;
            if ((available -= used) <= 0) break;
        }
        return transmitted;
    }

    private void checkReceptors(@Nonnull World world) {
        if (!this.receptorsDirty) {
            return;
        }
        this.receptors.clear();
        this.transmitter = world.func_175625_s(this.bc);
        NNList.FACING.apply((NNList.Callback)this);
        this.receptorIterator = this.receptors.listIterator();
        this.receptorsDirty = false;
    }

    public void apply(@Nonnull EnumFacing dir) {
        if (!(this.transmitter instanceof AbstractMachineEntity) || ((AbstractMachineEntity)this.transmitter).getIoMode(dir).canOutput()) {
            this.receptors.addIf((Object)PowerHandlerUtil.getCapability((ICapabilityProvider)this.transmitter.func_145831_w().func_175625_s(this.bc.func_177972_a(dir)), dir.func_176734_d()));
        }
    }
}

