/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.upgrades;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemUpgrades
extends Item
implements IHaveRenderers,
IAdvancedTooltipProvider {
    @Nonnull
    private static final String INVENTORY = "inventory";

    public static ItemUpgrades create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemUpgrades(modObject);
    }

    private ItemUpgrades(@Nonnull IModObject modObject) {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
    }

    public int getItemStackLimit(@Nonnull ItemStack stack) {
        return stack.func_77952_i() > 0 ? 1 : 64;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(modObject.getRegistryName(), INVENTORY)});
        ModelLoader.setCustomMeshDefinition((Item)this, this::getMRL);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    protected ModelResourceLocation getMRL(@Nonnull ItemStack stack) {
        return new ModelResourceLocation((ResourceLocation)NullHelper.first((Object)this.getRegistryName(), (Supplier[])new Supplier[0]), INVENTORY);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    protected ModelResourceLocation getMRL(ResourceLocation base, @Nonnull ResourceLocation registryName) {
        return new ModelResourceLocation(new ResourceLocation(registryName.func_110624_b(), base.func_110623_a()), "upgrade=" + registryName.func_110623_a());
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        return this.func_77658_a();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return super.func_77653_i(stack);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
        }
    }

    public static boolean isEnabled(@Nonnull ItemStack stack) {
        return NbtValue.ENABLED.getBoolean(stack);
    }

    @Nonnull
    public static ItemStack setEnabled(@Nonnull ItemStack stack, boolean value) {
        return NbtValue.ENABLED.setBoolean(stack, value);
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return ItemUpgrades.isEnabled(stack) || super.func_77636_d(stack);
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addCommonTooltipFromResources(list, (String)itemstack.func_77977_a());
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addBasicTooltipFromResources(list, (String)itemstack.func_77977_a());
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)this.func_77658_a());
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

