/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.api.farm.AbstractFarmerJoe;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmingTool;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomSeedFarmer
extends AbstractFarmerJoe {
    @Nonnull
    protected final Block plantedBlock;
    protected final int plantedBlockMeta;
    protected final int grownBlockMeta;
    @Nonnull
    protected final ItemStack seeds;
    @Nonnull
    protected Things tilledBlocks = new Things();
    protected boolean ignoreSustainCheck = false;
    protected boolean requiresTilling = true;
    protected boolean checkGroundForFarmland = false;
    protected boolean disableTreeFarm;

    public CustomSeedFarmer(@Nonnull Block plantedBlock, @Nonnull ItemStack seeds) {
        this(plantedBlock, 0, 7, seeds);
    }

    public CustomSeedFarmer(@Nonnull Block plantedBlock, int grownBlockMeta, @Nonnull ItemStack seeds) {
        this(plantedBlock, 0, grownBlockMeta, seeds);
    }

    public CustomSeedFarmer(@Nonnull Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, @Nonnull ItemStack seeds) {
        this.plantedBlock = plantedBlock;
        this.plantedBlockMeta = plantedBlockMeta;
        this.grownBlockMeta = grownBlockMeta;
        this.seeds = seeds;
        FarmersRegistry.slotItemsSeeds.add(seeds);
        this.addTilledBlock(Blocks.field_150458_ak);
    }

    public void clearTilledBlocks() {
        this.tilledBlocks = new Things();
    }

    public void addTilledBlock(@Nonnull Things block) {
        this.tilledBlocks.add(block);
    }

    public void addTilledBlock(@Nonnull Block block) {
        this.tilledBlocks.add(block);
    }

    public boolean isIgnoreGroundCanSustainCheck() {
        return this.ignoreSustainCheck;
    }

    @Nonnull
    public CustomSeedFarmer setIgnoreGroundCanSustainCheck(boolean ignoreSustainCheck) {
        this.ignoreSustainCheck = ignoreSustainCheck;
        return this;
    }

    public boolean isCheckGroundForFarmland() {
        return this.checkGroundForFarmland;
    }

    @Nonnull
    public CustomSeedFarmer setCheckGroundForFarmland(boolean checkGroundForFarmland) {
        this.checkGroundForFarmland = checkGroundForFarmland;
        return this;
    }

    @Nonnull
    protected IBlockState getPlantedBlockState() {
        return this.getPlantedBlock().func_176203_a(this.getPlantedBlockMeta());
    }

    @Deprecated
    public int getPlantedBlockMeta() {
        return this.plantedBlockMeta;
    }

    @Nonnull
    public Block getPlantedBlock() {
        return this.plantedBlock;
    }

    @Nonnull
    public ItemStack getSeeds() {
        return this.seeds;
    }

    public int getFullyGrownBlockMeta() {
        return this.grownBlockMeta;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return state.func_177230_c() == this.getPlantedBlock() && this.getFullyGrownBlockMeta() == meta;
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        return Prep.isValid(stack) && stack.func_77969_a(this.getSeeds());
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState state) {
        if (!farm.hasSeed(this.getSeeds(), bc)) {
            return false;
        }
        if (this.requiresTilling() && !this.isGroundTilled(farm, bc) && !farm.tillBlock(bc)) {
            return false;
        }
        return this.plantFromInventory(farm, bc);
    }

    public boolean requiresTilling() {
        return this.requiresTilling;
    }

    @Nonnull
    public CustomSeedFarmer setRequiresTilling(boolean requiresFarmland) {
        this.requiresTilling = requiresFarmland;
        return this;
    }

    protected boolean plantFromInventory(@Nonnull IFarmer farm, @Nonnull BlockPos bc) {
        World world = farm.getWorld();
        if (this.canPlant(farm, world, bc) && Prep.isValid(farm.takeSeedFromSupplies(bc, true)) && this.plant(farm, world, bc)) {
            farm.takeSeedFromSupplies(bc, false);
            return true;
        }
        return false;
    }

    @Nonnull
    protected IFarmingTool getHarvestTool() {
        return FarmingTool.HOE;
    }

    @Nonnull
    protected FarmNotification getNoHarvestToolNotification() {
        return FarmNotification.NO_HOE;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, final @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!this.canHarvest(farm, pos, state) || !farm.checkAction(FarmingAction.HARVEST, this.getHarvestTool())) {
            return null;
        }
        if (!farm.hasTool(this.getHarvestTool())) {
            farm.setNotification(this.getNoHarvestToolNotification());
            return null;
        }
        World world = farm.getWorld();
        FakePlayer joe = farm.startUsingItem(this.getHarvestTool());
        int fortune = farm.getLootingValue(this.getHarvestTool());
        final HarvestResult res = new HarvestResult(pos);
        NNList drops = new NNList();
        state.func_177230_c().getDrops((NonNullList)drops, (IBlockAccess)world, pos, state, fortune);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)joe.field_70170_p, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)joe);
        farm.registerAction(FarmingAction.HARVEST, this.getHarvestTool(), state, pos);
        boolean removed = false;
        for (ItemStack stack : drops) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            if (!removed && stack.func_77969_a(this.getSeeds())) {
                stack.func_190918_g(1);
                removed = true;
                if (!Prep.isValid(stack)) continue;
                res.addDrop(pos, stack.func_77946_l());
                continue;
            }
            res.addDrop(pos, stack.func_77946_l());
        }
        NNList.wrap(farm.endUsingItem(this.getHarvestTool())).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                res.addDrop(pos, drop.func_77946_l());
            }
        });
        if (removed) {
            if (!this.plant(farm, world, pos)) {
                res.addDrop(pos, this.getSeeds().func_77946_l());
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        return res;
    }

    protected boolean isGroundTilled(@Nonnull IFarmer farm, @Nonnull BlockPos plantingLocation) {
        return this.tilledBlocks.contains(farm.getBlockState(plantingLocation.func_177977_b()).func_177230_c());
    }

    protected boolean canPlant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc) {
        Block target = this.getPlantedBlock();
        BlockPos groundPos = bc.func_177977_b();
        IBlockState bs = world.func_180495_p(groundPos);
        Block ground = bs.func_177230_c();
        IPlantable plantable = (IPlantable)this.getPlantedBlock();
        return !(!target.func_176196_c(world, bc) || !ground.canSustainPlant(bs, (IBlockAccess)world, groundPos, EnumFacing.UP, plantable) && !this.ignoreSustainCheck || this.isCheckGroundForFarmland() && !this.isGroundTilled(farm, bc));
    }

    protected boolean plant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc) {
        world.func_180501_a(bc, Blocks.field_150350_a.func_176223_P(), 3);
        if (this.canPlant(farm, world, bc) && farm.checkAction(FarmingAction.PLANT, FarmingTool.HOE)) {
            world.func_180501_a(bc, this.getPlantedBlockState(), 3);
            farm.registerAction(FarmingAction.PLANT, FarmingTool.HOE, Blocks.field_150350_a.func_176223_P(), bc);
            return true;
        }
        return false;
    }

    public boolean doesDisableTreeFarm() {
        return this.disableTreeFarm;
    }
}

