/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.diagnostics;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.config.BaseConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class ModInterferenceWarner {
    @SubscribeEvent
    public static void onEvent(EnderIOLifecycleEvent.ServerAboutToStart.Pre event) {
        try {
            ModInterferenceWarner.warn(() -> Loader.isModLoaded((String)"spongeforge"), "SpongeForge is known for causing issues with Forge mods.\n\nIf you run into any issue with a Forge mod,\nfirst try uninstalling SpongeForge before you contact the mod author.", "spongeForgeConfirmed");
            ModInterferenceWarner.warn(() -> EnderIO.proxy.hasOptifine(), "Optifine is known for causing issues with mods.\n\nIf you run into any rendering issues,\nfirst try uninstalling Optifine before you contact the mod author.", "optifineConfirmed");
        }
        catch (StartupQuery.AbortedException abortedException) {
            // empty catch block
        }
    }

    public static void warn(Supplier<Boolean> check, String text, String config) {
        if (check.get().booleanValue()) {
            long value = ModInterferenceWarner.getInstallationSpecificValue();
            Property property = BaseConfig.F.getConfig().get("diagnostics", config, "0", "");
            System.out.println(value + " /" + property.getLong());
            if (property.getLong() != value) {
                if (StartupQuery.confirm((String)(text + "\n\nContinue loading anyway?"))) {
                    property.set(value);
                    BaseConfig.F.getConfig().save();
                    return;
                }
                StartupQuery.abort();
            }
        }
    }

    private static long getInstallationSpecificValue() {
        String installationSpecificString = System.getProperty("user.dir") + "5.3.0";
        CRC32 crc32 = new CRC32();
        crc32.update(installationSpecificString.getBytes(), 0, installationSpecificString.getBytes().length);
        return crc32.getValue();
    }
}

