/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.CapacitorKeyType;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.capacitor.Scaler;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.CapacitorKeyRegistry;
import crazypants.enderio.base.capacitor.ScalerFactory;
import crazypants.enderio.base.init.ModObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public enum CapacitorKey implements ICapacitorKey
{
    NO_POWER((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_INTAKE, "no_power"),
    LEGACY_ENERGY_INTAKE((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_INTAKE, "legacy_intake2"),
    LEGACY_ENERGY_BUFFER((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_BUFFER, "legacy_buffer"),
    LEGACY_ENERGY_USE((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_USE, "legacy_use"),
    LEGACY_ENERGY_EFFICIENCY((IModObject)ModObject.block_machine_base, CapacitorKeyType.ENERGY_EFFICIENCY, "legacy_efficiency");

    @Nonnull
    private final ResourceLocation registryName;
    @Nonnull
    private final IModObject owner;
    @Nonnull
    private final CapacitorKeyType valueType;
    @Nonnull
    private Scaler scaler = ScalerFactory.INVALID;
    private int baseValue = Integer.MIN_VALUE;

    private CapacitorKey(@Nonnull IModObject owner, CapacitorKeyType valueType, String shortname) {
        this.owner = owner;
        this.valueType = valueType;
        this.registryName = new ResourceLocation(owner.getRegistryName().func_110624_b(), owner.getRegistryName().func_110623_a() + "/" + shortname.toLowerCase(Locale.ENGLISH));
    }

    private CapacitorKey(IModObject owner, CapacitorKeyType valueType) {
        this(owner, valueType, valueType.name().toLowerCase(Locale.ENGLISH));
    }

    private CapacitorKey(IModObject owner, CapacitorKeyType valueType, boolean unused) {
        this.owner = owner;
        this.valueType = valueType;
        this.registryName = new ResourceLocation(owner.getRegistryName().func_110624_b(), owner.getRegistryName().func_110623_a() + "/" + this.name().toLowerCase(Locale.ENGLISH).toLowerCase(Locale.ENGLISH));
    }

    @Override
    public float getFloat(float level) {
        return (float)this.baseValue * this.scaler.scaleValue(level);
    }

    @Override
    public int getBaseValue() {
        return this.baseValue;
    }

    @Override
    @Nonnull
    public IModObject getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public CapacitorKeyType getValueType() {
        return this.valueType;
    }

    @Override
    @Nonnull
    public String getLegacyName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void setScaler(@Nonnull Scaler scaler) {
        this.scaler = scaler;
    }

    @Override
    public void setBaseValue(int baseValue) {
        this.baseValue = baseValue;
    }

    @Override
    public void validate() {
    }

    public final ICapacitorKey setRegistryName(String name) {
        throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
    }

    public final ICapacitorKey setRegistryName(ResourceLocation name) {
        this.setRegistryName(name.toString());
        return this;
    }

    @Override
    @Nonnull
    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public final Class<ICapacitorKey> getRegistryType() {
        return ICapacitorKey.class;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<ICapacitorKey> event) {
        for (CapacitorKey key : CapacitorKey.values()) {
            event.getRegistry().register((IForgeRegistryEntry)key);
            Log.debug("<capacitor key=\"", key.getRegistryName() + "\" base=\"\" scaler=\"\" />");
        }
        CapacitorKeyRegistry.setValue(NO_POWER.getRegistryName(), 0, ScalerFactory.FIXED, ScalerFactory.FIXED.name());
    }
}

