/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.holy;

import crazypants.enderio.util.FuncUtil;
import crazypants.enderio.util.SparseArray;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class HolyChunkData {
    private static Map<Chunk, SparseArray> DATA = new WeakHashMap<Chunk, SparseArray>();

    @SubscribeEvent
    public static void onSave(ChunkDataEvent.Save event) {
        FuncUtil.doIf(FuncUtil.runIf(DATA.get(event.getChunk()), SparseArray::toNBT), nbt -> event.getData().func_74782_a("enderio:hcd", (NBTBase)nbt));
    }

    @SubscribeEvent
    public static void onLoad(ChunkDataEvent.Load event) {
        if (event.getData().func_74764_b("enderio:hcd")) {
            DATA.put(event.getChunk(), new SparseArray(event.getData().func_74775_l("enderio:hcd")));
        }
    }

    public static void put(@Nonnull Chunk chunk, @Nonnull BlockPos pos, int value) {
        DATA.computeIfAbsent(chunk, unused -> new SparseArray()).put(HolyChunkData.makeKey(pos), value);
    }

    public static void del(@Nonnull Chunk chunk, @Nonnull BlockPos pos) {
        DATA.computeIfAbsent(chunk, unused -> new SparseArray()).delete(HolyChunkData.makeKey(pos));
    }

    public static int get(@Nonnull Chunk chunk, @Nonnull BlockPos pos) {
        SparseArray data = DATA.get(chunk);
        return data == null ? 0 : data.get(HolyChunkData.makeKey(pos));
    }

    public static int get(@Nonnull Chunk chunk, @Nonnull BlockPos pos, Supplier<Integer> defaultValue) {
        int value = HolyChunkData.get(chunk, pos);
        if (value == 0) {
            value = defaultValue.get();
            HolyChunkData.put(chunk, pos, value);
        }
        return value;
    }

    protected static int makeKey(@Nonnull BlockPos pos) {
        return pos.func_177958_n() & 0xF | (pos.func_177952_p() & 0xF) << 4 | pos.func_177956_o() << 8;
    }
}

