/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.network.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import elec332.core.api.network.IPacketDispatcher;
import elec332.core.api.network.IPacketRegistry;
import elec332.core.api.network.object.INetworkObject;
import elec332.core.api.network.object.INetworkObjectHandler;
import elec332.core.api.network.object.INetworkObjectManager;
import elec332.core.api.network.object.INetworkObjectReceiver;
import elec332.core.api.network.object.INetworkObjectSender;
import elec332.core.api.network.simple.ISimpleNetworkPacketManager;
import elec332.core.api.network.simple.ISimplePacket;
import elec332.core.api.network.simple.ISimplePacketHandler;
import elec332.core.network.IElecNetworkHandler;
import elec332.core.network.impl.DefaultByteBufFactory;
import elec332.core.network.impl.DefaultNetworkObjectManager;
import elec332.core.network.impl.DefaultSimpleNetworkHandler;
import gnu.trove.map.hash.TByteObjectHashMap;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

class DefaultNetworkHandler
implements IElecNetworkHandler,
DefaultByteBufFactory {
    private final SimpleNetworkWrapper networkWrapper;
    private final INetworkObjectManager networkObjectManager;
    private final ISimpleNetworkPacketManager simpleNetworkPacketManager;
    private final Map<String, ISimpleNetworkPacketManager> packetManagers;
    private final String channelName;
    private int i;
    private static final Field codec;
    private static final Field discriminators;
    private static final Field wrapperChannels;
    private static final Field registryChannels;

    DefaultNetworkHandler(SimpleNetworkWrapper networkWrapper) {
        this.networkWrapper = networkWrapper;
        this.channelName = DefaultNetworkHandler.getCurrentNameFrom(networkWrapper);
        this.i = DefaultNetworkHandler.getCurrentIndexFrom(networkWrapper);
        this.networkObjectManager = new DefaultNetworkObjectManager(this);
        this.simpleNetworkPacketManager = new DefaultSimpleNetworkHandler(this, this.channelName);
        this.packetManagers = Maps.newHashMap();
    }

    DefaultNetworkHandler(String channelName) {
        this.channelName = channelName.toLowerCase();
        this.networkWrapper = new SimpleNetworkWrapper(this.channelName);
        this.i = 0;
        this.networkObjectManager = new DefaultNetworkObjectManager(this);
        this.simpleNetworkPacketManager = new DefaultSimpleNetworkHandler(this, channelName);
        this.packetManagers = Maps.newHashMap();
    }

    @Nonnull
    ISimpleNetworkPacketManager getSimpleNetworkManager(String s) {
        if (s.equals(this.channelName)) {
            return this.simpleNetworkPacketManager;
        }
        ISimpleNetworkPacketManager ret = this.packetManagers.get(s);
        if (ret == null) {
            ret = new DefaultSimpleNetworkHandler(this, s);
            this.packetManagers.put(s, ret);
        }
        return (ISimpleNetworkPacketManager)Preconditions.checkNotNull((Object)ret);
    }

    @Override
    public <M extends IMessage, R extends IMessage> void registerPacket(IMessageHandler<M, R> messageHandler, Class<M> messageType, Side side) {
        this.networkWrapper.registerMessage(messageHandler, messageType, this.i, side);
        ++this.i;
    }

    @Override
    public void registerPacketsTo(IPacketRegistry packetRegistry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <N extends INetworkObjectReceiver> INetworkObjectHandler<?> registerNetworkObject(N networkObject) {
        return this.networkObjectManager.registerNetworkObject(networkObject);
    }

    @Override
    public <R extends INetworkObjectReceiver, S extends INetworkObjectSender> INetworkObjectHandler<S> registerNetworkObject(@Nullable R networkObjectR, @Nullable S networkObjectS) {
        return this.networkObjectManager.registerNetworkObject(networkObjectR, networkObjectS);
    }

    @Override
    public <N extends INetworkObject> INetworkObjectHandler<N> registerSpecialNetworkObject(N networkObject) {
        return this.networkObjectManager.registerSpecialNetworkObject(networkObject);
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public void sendToAll(IMessage message) {
        this.networkWrapper.sendToAll(message);
    }

    @Override
    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.networkWrapper.sendTo(message, player);
    }

    @Override
    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.networkWrapper.sendToAllAround(message, point);
    }

    @Override
    public void sendToDimension(IMessage message, int dimensionId) {
        this.networkWrapper.sendToDimension(message, dimensionId);
    }

    @Override
    public void sendToServer(IMessage message) {
        this.networkWrapper.sendToServer(message);
    }

    private static int getCurrentIndexFrom(SimpleNetworkWrapper networkWrapper) {
        try {
            FMLIndexedMessageToMessageCodec c = (FMLIndexedMessageToMessageCodec)codec.get(networkWrapper);
            byte[] ids = ((TByteObjectHashMap)discriminators.get(c)).keys();
            int ret = 0;
            for (byte b : ids) {
                ret = Math.max(ret, b);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getCurrentNameFrom(SimpleNetworkWrapper networkWrapper) {
        FMLEmbeddedChannel ch = DefaultNetworkHandler.getNetworkChannels(networkWrapper).get(Side.SERVER);
        Map<String, FMLEmbeddedChannel> map = DefaultNetworkHandler.getRegistryChannels().get(Side.SERVER);
        for (Map.Entry<String, FMLEmbeddedChannel> entry : map.entrySet()) {
            if (entry.getValue() != ch) continue;
            return entry.getKey();
        }
        throw new RuntimeException("Error finding name! Channel not found!");
    }

    static EnumMap<Side, Map<String, FMLEmbeddedChannel>> getRegistryChannels() {
        try {
            return (EnumMap)registryChannels.get(NetworkRegistry.INSTANCE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static EnumMap<Side, FMLEmbeddedChannel> getNetworkChannels(SimpleNetworkWrapper wrapper) {
        try {
            return (EnumMap)wrapperChannels.get(wrapper);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendToAll(ISimplePacket message) {
        this.simpleNetworkPacketManager.sendToAll(message);
    }

    @Override
    public void sendTo(ISimplePacket message, EntityPlayerMP player) {
        this.simpleNetworkPacketManager.sendTo(message, player);
    }

    @Override
    public void sendToAllAround(ISimplePacket message, NetworkRegistry.TargetPoint point) {
        this.simpleNetworkPacketManager.sendToAllAround(message, point);
    }

    @Override
    public void sendToDimension(ISimplePacket message, int dimensionId) {
        this.simpleNetworkPacketManager.sendToDimension(message, dimensionId);
    }

    @Override
    public void sendToServer(ISimplePacket message) {
        this.simpleNetworkPacketManager.sendToServer(message);
    }

    @Override
    public void sendToAll(ISimplePacket message, ISimplePacketHandler packetHandler) {
        this.simpleNetworkPacketManager.sendToAll(message, packetHandler);
    }

    @Override
    public void sendTo(ISimplePacket message, ISimplePacketHandler packetHandler, EntityPlayerMP player) {
        this.simpleNetworkPacketManager.sendTo(message, packetHandler, player);
    }

    @Override
    public void sendToAllAround(ISimplePacket message, ISimplePacketHandler packetHandler, NetworkRegistry.TargetPoint point) {
        this.simpleNetworkPacketManager.sendToAllAround(message, packetHandler, point);
    }

    @Override
    public void sendToDimension(ISimplePacket message, ISimplePacketHandler packetHandler, int dimensionId) {
        this.simpleNetworkPacketManager.sendToDimension(message, packetHandler, dimensionId);
    }

    @Override
    public void sendToServer(ISimplePacket message, ISimplePacketHandler packetHandler) {
        this.simpleNetworkPacketManager.sendToServer(message);
    }

    @Override
    public void sendToAll(ByteBuf data, ISimplePacketHandler packetHandler) {
        this.simpleNetworkPacketManager.sendToAll(data, packetHandler);
    }

    @Override
    public void sendTo(ByteBuf data, ISimplePacketHandler packetHandler, EntityPlayerMP player) {
        this.simpleNetworkPacketManager.sendTo(data, packetHandler, player);
    }

    @Override
    public void sendToAllAround(ByteBuf data, ISimplePacketHandler packetHandler, NetworkRegistry.TargetPoint point) {
        this.simpleNetworkPacketManager.sendToAllAround(data, packetHandler, point);
    }

    @Override
    public void sendToDimension(ByteBuf data, ISimplePacketHandler packetHandler, int dimensionId) {
        this.simpleNetworkPacketManager.sendToDimension(data, packetHandler, dimensionId);
    }

    @Override
    public void sendToServer(ByteBuf data, ISimplePacketHandler packetHandler) {
        this.simpleNetworkPacketManager.sendToServer(data, packetHandler);
    }

    @Override
    public void registerPacket(Class<? extends ISimplePacket> packetType) {
        this.simpleNetworkPacketManager.registerPacket(packetType);
    }

    @Override
    public void registerPacket(ISimplePacket packet) {
        this.simpleNetworkPacketManager.registerPacket(packet);
    }

    @Override
    public void registerPacketHandler(ISimplePacketHandler packetHandler) {
        this.simpleNetworkPacketManager.registerPacketHandler(packetHandler);
    }

    @Override
    public void registerPacket(Class<? extends ISimplePacket> packetType, ISimplePacketHandler packetHandler) {
        this.simpleNetworkPacketManager.registerPacket(packetType, packetHandler);
    }

    @Override
    public void registerPacket(ISimplePacket packet, ISimplePacketHandler packetHandler) {
        this.simpleNetworkPacketManager.registerPacket(packet, packetHandler);
    }

    @Override
    public IPacketDispatcher getPacketDispatcher() {
        return this;
    }

    static {
        try {
            codec = SimpleNetworkWrapper.class.getDeclaredField("packetCodec");
            discriminators = FMLIndexedMessageToMessageCodec.class.getDeclaredField("discriminators");
            wrapperChannels = SimpleNetworkWrapper.class.getDeclaredField("channels");
            registryChannels = NetworkRegistry.class.getDeclaredField("channels");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

