/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.loader.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.ElecCore;
import elec332.core.api.annotations.StaticLoad;
import elec332.core.api.client.model.loading.IModelHandler;
import elec332.core.api.client.model.loading.ModelHandler;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@StaticLoad
@SideOnly(value=Side.CLIENT)
@ASMDataProcessor(value={LoaderState.PREINITIALIZATION})
enum ElecModelManager implements IASMDataProcessor
{
    INSTANCE;

    private List<IModelHandler> modelHandlers = Lists.newArrayList();

    private ElecModelManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void processASMData(IASMDataHelper asmData, LoaderState state) {
        ArrayList list = Lists.newArrayList();
        for (ASMDataTable.ASMData data : asmData.getAnnotationList(ModelHandler.class)) {
            String s = data.getClassName();
            try {
                list.add(Class.forName(s).newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Error registering ModelHandler class: " + s, e);
            }
        }
        ImmutableList param = ImmutableList.copyOf((Collection)list);
        for (Object o : list) {
            IModelHandler modelHandler;
            if (!(o instanceof IModelHandler) || !(modelHandler = (IModelHandler)o).enabled()) continue;
            this.modelHandlers.add(modelHandler);
            modelHandler.getModelHandlers((List<?>)param);
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ElecCore.logger.info("Registering models");
        for (IModelHandler modelHandler : this.modelHandlers) {
            modelHandler.preHandleModels();
        }
    }

    Set<ModelResourceLocation> registerBakedModels(IRegistry<ModelResourceLocation, IBakedModel> registry) {
        ElecCore.logger.info("Handling models");
        HashSet ret = Sets.newHashSet();
        IBakedModel missingModel = (IBakedModel)registry.func_82594_a((Object)ModelBakery.field_177604_a);
        HashMap models = Maps.newHashMap();
        for (IModelHandler iModelHandler : this.modelHandlers) {
            models.putAll(iModelHandler.registerBakedModels(arg_0 -> registry.func_82594_a(arg_0)));
        }
        for (Map.Entry entry : models.entrySet()) {
            registry.func_82595_a(entry.getKey(), MoreObjects.firstNonNull(entry.getValue(), (Object)missingModel));
            ret.add(entry.getKey());
        }
        return ret;
    }

    void cleanModelLoadingExceptions(Map<ResourceLocation, Exception> locationExceptions) {
        for (IModelHandler modelHandler : this.modelHandlers) {
            modelHandler.cleanExceptions(locationExceptions);
        }
    }
}

