/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.item;

import elec332.core.api.client.IColoredItem;
import elec332.core.api.client.IIconRegistrar;
import elec332.core.api.client.model.IElecModelBakery;
import elec332.core.api.client.model.IElecQuadBakery;
import elec332.core.api.client.model.IElecTemplateBakery;
import elec332.core.client.RenderHelper;
import elec332.core.client.model.loading.INoJsonItem;
import elec332.core.item.AbstractItem;
import elec332.core.item.IEnumItem;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnumBased<E extends Enum<E>>
extends AbstractItem
implements INoJsonItem,
IColoredItem {
    protected final Class<E> clazz;
    protected final E[] values;
    private final boolean nji;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[][] textures;
    @SideOnly(value=Side.CLIENT)
    private IBakedModel[] models;

    public ItemEnumBased(Class<E> clazz) {
        this.clazz = clazz;
        this.values = (Enum[])clazz.getEnumConstants();
        this.nji = this.values[0] instanceof INoJsonItem;
        this.func_77627_a(true);
        ((IEnumItem)this.values[0]).initializeItem(this);
    }

    public ItemStack getStackFromType(E type) {
        return this.getStackFromType(type, 1);
    }

    public ItemStack getStackFromType(E type, int amount) {
        return new ItemStack((Item)this, amount, ((Enum)type).ordinal());
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int tintIndex) {
        int i = stack.func_77952_i();
        return i >= this.values.length ? -1 : ((IEnumItem)this.values[i]).getColorFromItemStack(stack, tintIndex);
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (E e : this.values) {
            if (!((IEnumItem)e).shouldShow()) continue;
            subItems.add((Object)this.getStackFromType(e));
        }
    }

    @Override
    @Nonnull
    public String func_77667_c(ItemStack stack) {
        Object e;
        Object v0 = e = stack == null ? null : this.get(stack.func_77952_i());
        if (e == null) {
            return super.func_77667_c(stack);
        }
        return ((IEnumItem)e).getUnlocalizedName(stack);
    }

    @Override
    public void registerTextures(IIconRegistrar iconRegistrar) {
        this.textures = new TextureAtlasSprite[this.values.length][];
        for (E e : this.values) {
            if (this.nji) {
                ((INoJsonItem)e).registerTextures(iconRegistrar);
                continue;
            }
            ResourceLocation[] rls = ((IEnumItem)e).getTextures();
            this.textures[((Enum)e).ordinal()] = new TextureAtlasSprite[rls.length];
            for (int i = 0; i < rls.length; ++i) {
                this.textures[((Enum)e).ordinal()][i] = iconRegistrar.registerSprite(rls[i]);
            }
        }
    }

    @Override
    public IBakedModel getItemModel(ItemStack stack, World world, EntityLivingBase entity) {
        int i = stack.func_77952_i();
        E e = this.get(i);
        if (e == null) {
            return RenderHelper.getMissingModel();
        }
        if (this.nji) {
            return ((INoJsonItem)e).getItemModel(stack, world, entity);
        }
        return this.models[i];
    }

    @Override
    public void registerModels(IElecQuadBakery quadBakery, IElecModelBakery modelBakery, IElecTemplateBakery templateBakery) {
        this.models = new IBakedModel[this.values.length];
        for (E e : this.values) {
            if (this.nji) {
                ((INoJsonItem)e).registerModels(quadBakery, modelBakery, templateBakery);
                continue;
            }
            this.models[((Enum)e).ordinal()] = modelBakery.itemModelForTextures(this.textures[((Enum)e).ordinal()]);
        }
    }

    public int getDamage(ItemStack stack) {
        if (this.values.length <= super.getDamage(stack)) {
            stack.func_77964_b(0);
        }
        return super.getDamage(stack);
    }

    private E get(int i) {
        return i >= this.values.length ? null : (E)this.values[i];
    }
}

