/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory;

import elec332.core.util.InventoryHelper;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DoubleItemHandler<I1 extends IItemHandlerModifiable, I2 extends IItemHandlerModifiable>
implements IItemHandlerModifiable {
    private final I1 i1;
    private final I2 i2;
    private final int i1Size;
    private final int totalSize;

    public DoubleItemHandler(I1 i1, I2 i2) {
        this.i1 = i1;
        this.i2 = i2;
        this.i1Size = i1.getSlots();
        this.totalSize = this.i1Size + i2.getSlots();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot < this.i1Size) {
            this.i1.setStackInSlot(slot, stack);
        } else {
            this.i2.setStackInSlot(slot - this.i1Size, stack);
        }
    }

    public int getSlots() {
        return this.totalSize;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.i1Size) {
            return this.i1.getStackInSlot(slot);
        }
        return this.i2.getStackInSlot(slot - this.i1Size);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < this.i1Size) {
            return this.i1.insertItem(slot, stack, simulate);
        }
        return this.i2.insertItem(slot - this.i1Size, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < this.i1Size) {
            return this.i1.extractItem(slot, amount, simulate);
        }
        return this.i2.extractItem(slot - this.i1Size, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        if (slot < this.i1Size) {
            return this.i1.getSlotLimit(slot);
        }
        return this.i2.getSlotLimit(slot - this.i1Size);
    }

    public boolean insertItem(ItemStack stack, boolean simulate) {
        return InventoryHelper.addItemToInventory((IItemHandler)this, stack, simulate);
    }
}

