/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.internal;

import elec332.core.api.annotations.StaticLoad;
import elec332.core.grid.internal.GridEventInputHandler;
import elec332.core.grid.internal.WorldEventHandler;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@StaticLoad
class GridEventHandler {
    GridEventHandler() {
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            GridEventInputHandler.INSTANCE.chunkLoad(event.getChunk());
        }
    }

    @SubscribeEvent
    public void chunkUnLoad(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            GridEventInputHandler.INSTANCE.chunkUnLoad(event.getChunk());
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onNeighborChange(BlockEvent.NeighborNotifyEvent event) {
        if (!event.getWorld().field_72995_K) {
            GridEventInputHandler.INSTANCE.onBlockNotify(event.getWorld(), event.getPos(), event.getState());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            GridEventInputHandler.INSTANCE.tickEnd();
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            GridEventInputHandler.INSTANCE.worldUnload(world);
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            world.func_72848_b((IWorldEventListener)WorldEventHandler.INSTANCE);
            world.func_72954_a((IWorldEventListener)WorldEventHandler.INSTANCE);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new GridEventHandler());
    }
}

