/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import elec332.core.ElecCore;
import elec332.core.api.annotations.StaticLoad;
import elec332.core.api.data.IExternalSaveHandler;
import elec332.core.util.FMLUtil;
import elec332.core.util.IOHelper;
import elec332.core.world.WorldHelper;
import java.io.File;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@StaticLoad
public enum SaveHandler {
    INSTANCE;

    private final ListMultimap<ModContainer, IExternalSaveHandler> saveHandlers = LinkedListMultimap.create();
    private static final String folder = "extradata";
    private boolean loaded = false;

    public boolean registerSaveHandler(ModContainer mc, IExternalSaveHandler saveHandler) {
        if (!FMLUtil.isInModInitialisation()) {
            return false;
        }
        this.saveHandlers.put((Object)mc, (Object)saveHandler);
        return true;
    }

    private void load(World world) {
        File file = new File(world.func_72860_G().func_75765_b(), folder);
        IOHelper.ensureExists(file);
        for (ModContainer mc : this.saveHandlers.keySet()) {
            NBTTagCompound tag = IOHelper.readWithPossibleBackup(new File(file, mc.getModId() + ".dat"), IOHelper.NBT_COMPRESSED_IO);
            for (IExternalSaveHandler saveHandler : this.saveHandlers.get((Object)mc)) {
                Preconditions.checkNotNull((Object)world);
                Preconditions.checkNotNull((Object)saveHandler);
                Preconditions.checkNotNull((Object)tag);
                saveHandler.load(world.func_72860_G(), world.func_72912_H(), tag.func_74775_l(saveHandler.getName()));
            }
        }
        this.loaded = true;
    }

    private void save(World world) {
        if (!this.loaded && !ElecCore.suppressSpongeIssues) {
            ElecCore.logger.error("World is unloading before data has been loaded, skipping data saving...");
            ElecCore.logger.error("This probably happened due to a crash in EG worldgen.");
            return;
        }
        File file = new File(world.func_72860_G().func_75765_b(), folder);
        for (ModContainer mc : this.saveHandlers.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            for (IExternalSaveHandler saveHandler : this.saveHandlers.get((Object)mc)) {
                NBTTagCompound n = saveHandler.save(world.func_72860_G(), world.func_72912_H());
                if (n == null) continue;
                tag.func_74782_a(saveHandler.getName(), (NBTBase)n);
            }
            IOHelper.writeWithBackup(new File(file, mc.getModId() + ".dat"), tag, IOHelper.NBT_COMPRESSED_IO);
        }
    }

    private void unLoad(World world) {
        this.loaded = false;
        for (ModContainer mc : this.saveHandlers.keySet()) {
            for (IExternalSaveHandler saveHandler : this.saveHandlers.get((Object)mc)) {
                saveHandler.nullifyData();
            }
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (this.isOverworld(event.getWorld())) {
                INSTANCE.load(event.getWorld());
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (this.isOverworld(event.getWorld())) {
                INSTANCE.save(event.getWorld());
            }
        }

        @SubscribeEvent
        public void worldUnload(WorldEvent.Unload event) {
            if (this.isOverworld(event.getWorld())) {
                INSTANCE.unLoad(event.getWorld());
            }
        }

        private boolean isOverworld(World world) {
            return !world.field_72995_K && WorldHelper.getDimID(world) == 0 && world.getClass() == WorldServer.class;
        }
    }
}

