/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import elec332.core.api.config.Configurable;
import elec332.core.api.config.IConfigElementSerializer;
import elec332.core.api.config.IConfigWrapper;
import elec332.core.api.config.IConfigurableElement;
import elec332.core.config.CategoryAsConfig;
import elec332.core.util.FMLUtil;
import elec332.core.util.ReflectionHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.LoaderState;

public class ConfigWrapper
implements IConfigWrapper {
    private Configuration configuration;
    private List<Object> instances;
    private boolean hasInit;
    private List<CategoryData> categoryDataList;
    private Set<String> categories;
    private List<IConfigurableElement> configurableElements;
    private boolean isReloading;
    private static List<IConfigElementSerializer> serializers = Lists.newArrayList();

    public ConfigWrapper(Configuration configuration) {
        this.configuration = configuration;
        this.instances = Lists.newArrayList();
        this.hasInit = false;
        this.categoryDataList = Lists.newArrayList();
        this.categories = Sets.newHashSet();
        this.configurableElements = Lists.newArrayList();
        this.isReloading = false;
    }

    @Override
    public void registerConfig(Object o) {
        if (this.hasInit) {
            throw new RuntimeException("You cannot register configs after init");
        }
        this.instances.add(o);
    }

    @Override
    @Nonnull
    public ConfigWrapper setCategoryData(String category, String description) {
        for (CategoryData cat : this.categoryDataList) {
            if (!category.equals(cat.getCategory())) continue;
            throw new IllegalArgumentException();
        }
        this.categoryDataList.add(new CategoryData(category, description));
        this.addRegisteredCategory(category);
        return this;
    }

    protected void addRegisteredCategory(String category) {
        if (!this.categories.contains(category.toLowerCase())) {
            this.categories.add(category.toLowerCase());
        }
    }

    @Override
    @Nonnull
    public List<String> getRegisteredCategories() {
        return ImmutableList.copyOf(this.categories);
    }

    @Override
    public boolean hasBeenLoaded() {
        return this.hasInit;
    }

    @Override
    public void registerConfigWithInnerClasses(Object obj) {
        this.registerConfig(obj);
        for (Class clazz : Lists.reverse((List)Lists.newArrayList((Object[])obj.getClass().getDeclaredClasses()))) {
            if (clazz.isInterface()) continue;
            try {
                this.registerConfigWithInnerClasses(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Error registering config: " + clazz.getName());
            }
        }
    }

    @Override
    public void registerConfigurableElement(IConfigurableElement configurableElement) {
        this.configurableElements.add(configurableElement);
    }

    @Override
    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void refresh(boolean load) {
        this.refreshInternal(load);
    }

    private void refreshInternal(boolean load) {
        this.isReloading = true;
        if (load) {
            this.configuration.load();
        }
        if (!this.hasInit) {
            this.hasInit = true;
        }
        for (CategoryData categoryData : this.categoryDataList) {
            this.configuration.setCategoryComment(categoryData.getCategory(), categoryData.getDescription());
        }
        for (Object o : this.instances) {
            boolean oldAccess;
            Class objClass = o.getClass();
            if (o instanceof Class) {
                objClass = (Class)o;
                o = null;
            }
            String classCategory = "general";
            if (objClass.isAnnotationPresent(Configurable.Class.class)) {
                Configurable.Class configClass = objClass.getAnnotation(Configurable.Class.class);
                if (configClass.inherit()) {
                    Class[] classes = ReflectionHelper.getAllTillMainClass(objClass);
                    StringBuilder s = new StringBuilder();
                    for (Class clazz : classes) {
                        String s1;
                        if (!clazz.isAnnotationPresent(Configurable.Class.class)) continue;
                        if (s.length() != 0) {
                            s.append(".");
                        }
                        s.append((s1 = clazz.getAnnotation(Configurable.Class.class).category()).equals("general") ? clazz.getSimpleName() : s1);
                    }
                    classCategory = s.toString();
                } else {
                    classCategory = configClass.category();
                }
                String comment = configClass.comment();
                if (!comment.equals("")) {
                    this.configuration.setCategoryComment(classCategory, comment);
                }
            }
            for (Field field : objClass.getDeclaredFields()) {
                try {
                    oldAccess = field.isAccessible();
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Configurable.class)) {
                        Configurable configurable = field.getAnnotation(Configurable.class);
                        Object oldValue = field.get(o);
                        String category = configurable.category();
                        if (category.equals("general")) {
                            category = classCategory;
                        }
                        this.addRegisteredCategory(category);
                        boolean serialized = false;
                        for (IConfigElementSerializer serializer : serializers) {
                            if (!serializer.setData(field.getType(), o, field, configurable, this.configuration, category, oldValue, configurable.comment())) continue;
                            serialized = true;
                            break;
                        }
                        if (!serialized) {
                            throw new RuntimeException("Could not find serializer for type " + field.getType());
                        }
                    }
                    field.setAccessible(oldAccess);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            for (AccessibleObject accessibleObject : objClass.getDeclaredMethods()) {
                try {
                    oldAccess = accessibleObject.isAccessible();
                    ((Method)accessibleObject).setAccessible(true);
                    if (accessibleObject.isAnnotationPresent(Configurable.class) && ((Method)accessibleObject).getParameterTypes().length == 0) {
                        Configurable configurable = ((Method)accessibleObject).getAnnotation(Configurable.class);
                        if (this.configuration.getBoolean(((Method)accessibleObject).getName(), configurable.category(), configurable.enabledByDefault(), configurable.comment())) {
                            ((Method)accessibleObject).invoke(o, new Object[0]);
                        }
                    }
                    ((Method)accessibleObject).setAccessible(oldAccess);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        for (IConfigurableElement cfgElement : this.configurableElements) {
            cfgElement.reconfigure(this.configuration);
        }
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
        this.isReloading = false;
    }

    @Override
    @Nonnull
    public IConfigWrapper wrapCategoryAsConfigWrapper(String category) {
        return new ConfigWrapper(this.wrapCategoryAsConfig(category)){

            @Override
            public void refresh(boolean load) {
                if (load && ConfigWrapper.this.isReloading) {
                    throw new IllegalStateException("Cannot active load config file while master config is reloading.");
                }
                super.refresh(load);
            }

            @Override
            protected void addRegisteredCategory(String category) {
                super.addRegisteredCategory(category);
                ConfigWrapper.this.addRegisteredCategory(category + "." + category);
            }
        };
    }

    @Override
    @Nonnull
    public Configuration wrapCategoryAsConfig(String category) {
        this.addRegisteredCategory(category);
        return new CategoryAsConfig(category, this.configuration){

            @Override
            public void load() {
                if (ConfigWrapper.this.isReloading) {
                    throw new IllegalStateException("Cannot load config while master configuration is reloading.");
                }
                super.load();
            }

            @Override
            public void save() {
                if (ConfigWrapper.this.isReloading) {
                    throw new IllegalStateException("Cannot save config while master configuration is reloading.");
                }
                super.save();
            }
        };
    }

    public static Configuration wrapCategoryAsConfig(Configuration configuration, String category) {
        return new CategoryAsConfig(category, configuration);
    }

    public static void registerConfigElementSerializer(IConfigElementSerializer serializer) {
        if (FMLUtil.hasReachedState(LoaderState.INITIALIZATION)) {
            throw new RuntimeException("Cannot register config element serializer after PreInit!");
        }
        serializers.add(serializer);
    }

    private final class CategoryData {
        private final String category;
        private final String desc;

        private CategoryData(String category, String desc) {
            this.category = category;
            this.desc = desc;
        }

        private String getCategory() {
            return this.category;
        }

        private String getDescription() {
            return this.desc;
        }
    }
}

