/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.data;

import com.google.common.base.Preconditions;
import elec332.core.api.data.IExternalSaveHandler;
import elec332.core.api.util.IClearable;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTSerializableSaveHandler
implements IExternalSaveHandler {
    private final INBTSerializable<NBTTagCompound> nbtSerializable;
    private final IClearable clearable;
    private final String name;

    public NBTSerializableSaveHandler(String name, INBTSerializable<NBTTagCompound> nbtSerializable) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.nbtSerializable = (INBTSerializable)Preconditions.checkNotNull(nbtSerializable);
        this.clearable = nbtSerializable instanceof IClearable ? (IClearable)nbtSerializable : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load(ISaveHandler saveHandler, WorldInfo info, NBTTagCompound tag) {
        this.nbtSerializable.deserializeNBT((NBTBase)tag);
    }

    @Override
    @Nullable
    public NBTTagCompound save(ISaveHandler saveHandler, WorldInfo info) {
        return (NBTTagCompound)this.nbtSerializable.serializeNBT();
    }

    @Override
    public void nullifyData() {
        if (this.clearable != null) {
            this.clearable.clear();
        }
    }
}

